#! /usr/bin/wish

package require BLT
#setting enviremental variables
set platform $tcl_platform(os)
if {[regexp {^Linux*} $platform]} {
	if {[file exists "$env(HOME)/.DoDeCalculator"] == 1} {
		source "$env(HOME)/.DoDeCalculator"
	} else {
		tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		exit	
	}
} elseif {[regexp {^Windows NT*} $platform]} {
	if {[file exists "$env(HOME)/DoDeCalculator.init"] == 1} {
		source "$env(HOME)/DoDeCalculator.init"
	} else {
		tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		exit
	}
} elseif {[regexp {^Windows 95\/98*} $platform]} {
	if {[file exists "$env(HOME)/DoDeCalculator.init"] == 1} {
		source"$env(HOME)/DoDeCalculator.init"
	} else {
		tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		exit
	}
}
set Zeilennr 1
if {[file exists "$installdir/$language.txt"] == 1} {
	set Datei [open "$installdir/$language.txt" r]
	while {[gets $Datei Zeile] >= 0} {
		if {[regexp ^\# $Zeile] || $Zeile == "" } {
		continue
		}
		set textpart($Zeilennr) $Zeile
	incr Zeilennr 1
	}
}
unset Zeilennr
close $Datei
source $installdir/procs.tcl

########################################################################################################################
#Graphische Benutzeroberf�he
########################################################################################################################
# set variables which are neded
set kappa ""
set fehler_depha 0
set filename ""
set cindex ""
set cindex1 ""
set cindex2 ""
set rindex ""
set rindex1 ""
set rindex2 ""
set homedir $env(HOME)
set tcl_precision 17
set pi 3.14159265358979323846 
blt::tree create tree0
set tree ::tree0

wm title . "$textpart(1)"

#Mainframes: create menuebar and mainwindow
frame .mbar -relief raised -bd 2
frame .main -relief raised -bd 2 
pack .mbar .main -side top -fill x



#############################################################################################################
#split mainwindow
#############################################################################################################


# 1) picturefield
frame .main.bild -relief raised -borderwidth 2 -height 8c

# source picturefields
set colortau1 black
set colortau2 black
set unteneins ""
set untenzwei ""
set sym ""
set sym1 ""
set sym2 ""
set sym3 ""
set symnb ""
set symnb_b ""
set symnbm1 ""
set symnbh ""
set symnbh_b ""
set symnbd ""
set symnbd_b ""

source $installdir/pulsinadequate.tk
source $installdir/pulspc7.tk


# 2) resultwindow
frame .main.oben -relief raised  -borderwidth 2

# 3) labelfield => Pulsesequemze
frame .main.oben2 -relief raised -borderwidth 2

# 4) Entryfield
frame .main.mitte -relief raised -borderwidth 2

# 5) Buttonfield
frame .main.unten -relief raised -borderwidth 2

pack .main.oben2 .main.bild .main.mitte .main.oben .main.unten -side top -fill x -padx 2


#split resultwindow
frame .main.oben.links
frame .main.oben.rechts
pack .main.oben.links  -side left
pack .main.oben.rechts -side right

#create resultwindow
entry .main.oben.rechts.e_ergebnis -relief sunken -textvariable Ergebnis -width 20 -justify center 
label .main.oben.rechts.l_fehler -relief sunken -textvariable Fehler -width 20
label .main.oben.rechts.l_nue_dip_max -relief sunken -textvariable nue_dip_max -width 20
label .main.oben.links.l_textergebnis -text "$textpart(2)"
label .main.oben.links.l_textfehler -text "$textpart(3)"
label .main.oben.links.l_textnue_dip_max -text "$textpart(4)"
bind .main.oben.rechts.e_ergebnis <B1-Motion> {set depha ""}
pack .main.oben.links.l_textergebnis .main.oben.links.l_textfehler .main.oben.links.l_textnue_dip_max -side top -anchor w
pack .main.oben.rechts.e_ergebnis .main.oben.rechts.l_fehler .main.oben.rechts.l_nue_dip_max  -side top -fill x -anchor n

# create label for the pulse sequenze field
label .main.oben2.l_funktionsname -text "$textpart(5)"
frame .main.oben2.buttonframe
pack .main.oben2.l_funktionsname -fill x
pack .main.oben2.buttonframe -side top -anchor nw -fill x


frame .main.oben2.buttonframe.left
frame .main.oben2.buttonframe.right
frame .main.oben2.buttonframe.mid
frame .main.oben2.buttonframe.mid2
pack .main.oben2.buttonframe.left  -side left -anchor nw
pack .main.oben2.buttonframe.mid .main.oben2.buttonframe.mid2 .main.oben2.buttonframe.right -side right -anchor ne -fill x

#create pulse sequence window
label .main.oben2.buttonframe.left.l_dqexc1 -text "$textpart(6)"
label .main.oben2.buttonframe.left.l_dqexc2 -text ""
radiobutton .main.oben2.buttonframe.left.rb_inadequate -text "$textpart(7)" -variable Funktionsname -value funktioninadequate -command {
	pack forget .main.mitte.links.l_tau_exc
	pack forget .main.mitte.rechts.e_tau_exc
	set tau_exc ""
	foreach Element [winfo children .main.bild] {
		pack forget $Element
	}
	pack .main.bild.funktioninadequate -anchor center -fill x -fill y
	focus .main.oben2.buttonframe.right.menups
}
radiobutton .main.oben2.buttonframe.left.rb_pc7 -text "$textpart(8)" -variable Funktionsname -value funktionpostc7 -command {
	set tau_exc ""
	pack .main.mitte.links.l_tau_exc  -side bottom -anchor w
	pack .main.mitte.rechts.e_tau_exc  -side bottom -anchor w
	foreach Element [winfo children .main.bild] {
		pack forget $Element
	}
	pack .main.bild.funktionpostc7 -anchor center -fill x -fill y
	focus .main.oben2.buttonframe.right.menups
}
pack .main.oben2.buttonframe.left.l_dqexc1 .main.oben2.buttonframe.left.l_dqexc2 .main.oben2.buttonframe.left.rb_inadequate .main.oben2.buttonframe.left.rb_pc7   -side top -anchor nw

# creating shortcut field
label .main.oben2.buttonframe.mid.l_short -text "$textpart(9)"
label .main.oben2.buttonframe.mid.l_short2 -text "$textpart(10)"
label .main.oben2.buttonframe.mid.l_short3 -relief sunken -width 10 -text ""
pack .main.oben2.buttonframe.mid.l_short .main.oben2.buttonframe.mid.l_short2 .main.oben2.buttonframe.mid.l_short3 -side top -anchor n

#create kappa field
label .main.oben2.buttonframe.mid2.l_kappa -text "$textpart(11)"
label .main.oben2.buttonframe.mid2.l_kappa2 -text ""
label .main.oben2.buttonframe.mid2.l_kappa3 -relief sunken -width 20 -textvariable kappa
pack  .main.oben2.buttonframe.mid2.l_kappa .main.oben2.buttonframe.mid2.l_kappa2 .main.oben2.buttonframe.mid2.l_kappa3 -side top -anchor n

# cearting dephasinng menue
label .main.oben2.buttonframe.right.l_DQdph1 -text "$textpart(12)"
label .main.oben2.buttonframe.right.l_DQdph2 -text "$textpart(13)"
pack .main.oben2.buttonframe.right.l_DQdph1 .main.oben2.buttonframe.right.l_DQdph2  -side top -anchor n

#button
menubutton .main.oben2.buttonframe.right.menups -text "$textpart(14)" -underline 0 -menu .main.oben2.buttonframe.right.menups.menue -relief raised -width 30
pack .main.oben2.buttonframe.right.menups -anchor n

#######################################################################################################################################
#create menu for the pulse-sequenze selection
#######################################################################################################################################
source $mendat
###################################################################################################################################

# spliting entry window
frame .main.mitte.links
frame .main.mitte.rechts
pack .main.mitte.links  -side left
pack .main.mitte.rechts  -side right


#creating entry window
label .main.mitte.links.l_depha -text "$textpart(15)"
entry .main.mitte.rechts.e_depha -textvariable depha
label .main.mitte.links.l_fehler_depha -text "$textpart(16)"
entry .main.mitte.rechts.e_fehler_depha -textvariable fehler_depha
label .main.mitte.links.l_tau -text "$textpart(17)"
entry .main.mitte.rechts.e_tau -textvariable tau
label .main.mitte.links.l_tau_exc -text "$textpart(18)"
entry .main.mitte.rechts.e_tau_exc -textvariable tau_exc
pack .main.mitte.links.l_depha .main.mitte.links.l_fehler_depha .main.mitte.links.l_tau -side top -anchor w
pack .main.mitte.rechts.e_depha .main.mitte.rechts.e_fehler_depha .main.mitte.rechts.e_tau -side top -anchor w

#bindings for the input-panel (only nubers aceptet, highlight the right time in the pulse sequence focus)
#only acept numbers
bind .main.mitte.rechts.e_depha <FocusOut> {
	if {[regexp {^[0-9]*\.?[0-9]+$} $depha] || $depha == ""} {
		continue
	} else {
		set depha ""
		tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
	}
}
#set foccus
bind .main.mitte.rechts.e_depha <KeyPress-Return> {
	focus .main.mitte.rechts.e_fehler_depha
}
#only acept numbers
bind .main.mitte.rechts.e_fehler_depha <FocusOut> {
	if {[regexp {^[0-9]*\.?[0-9]+$} $fehler_depha] || $fehler_depha == ""} {
		continue
	} else {
		set fehler_depha ""
		tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
	}
}
#set focus
bind .main.mitte.rechts.e_fehler_depha <KeyPress-Return> {
	focus .main.mitte.rechts.e_tau
}
#cange color in the picuture
bind .main.mitte.rechts.e_tau <FocusIn> {
	set colortau2 red
	redraw .main.bild $installdir
}
#only acept numbers
bind .main.mitte.rechts.e_tau <FocusOut> {
	if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} $tau] || $tau == ""} {
		if {[regexp {[s]$} $tau]} {
			set tau [format %%f [string trimright $tau {s}]]
		} elseif {[regexp {[m]$} $tau]} {
			set tau [format %%f [expr [format %%.1f [string trimright $tau {m}]]/1000]]
		} elseif {[regexp {[u]$} $tau]} {
			set tau [format %%f [expr [format %%.1f [string trimright $tau {u}]]/1000000]]
		}
		if {$tau == 0} {
			set tau ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
		set colortau2 black
		redraw .main.bild $installdir
		continue
} else {
	set tau ""
	tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
}
}
#set focus
bind .main.mitte.rechts.e_tau <KeyPress-Return> {
	if {$Funktionsname=="funktionpostc7"} {
		focus .main.mitte.rechts.e_tau_exc
	} else {
		if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} $tau] || $tau == ""} {
			set colortau1 black
			redraw .main.bild $installdir
			if {[regexp {[s]$} $tau]} {
				set tau [format %%f [string trimright $tau {s}]]
			} elseif {[regexp {[m]$} $tau]} {
				set tau [format %%f [expr [format %%.1f [string trimright $tau {m}]]/1000]]
			} elseif {[regexp {[u]$} $tau]} {
				set tau [format %%f [expr [format %%.1f [string trimright $tau {u}]]/1000000]]
			}
			if {$tau == 0} {
				set tau ""
				tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
				break
			}
			.main.unten.b_Berechnen invoke
			continue
		} else {
			set tau ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
	}
}
#cange color in the picuture
bind .main.mitte.rechts.e_tau_exc <FocusIn> {
	set colortau1 red
	redraw .main.bild $installdir
}
#only acept numbers
bind .main.mitte.rechts.e_tau_exc <FocusOut> {
	if {[regexp {^[0-9]*\.?[0-9]+[sum]?$} $tau_exc] || $tau_exc == ""} {
		set colortau1 black
		redraw .main.bild $installdir
		if {[regexp {[s]$} $tau_exc]} {
			set tau_exc [format %%f [string trimright $tau_exc {s}]]
		} elseif {[regexp {[m]$} $tau_exc]} {
			set tau_exc [format %%f [expr [format %%.1f [string trimright $tau_exc {m}]]/1000]]
		} elseif {[regexp {[u]$} $tau_exc]} {
			set tau_exc [format %%f [expr [format %%.1f [string trimright $tau_exc {u}]]/1000000]]
		}
		if {$tau_exc == 0} {
			set tau ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
		continue
	} else {
		set tau_exc ""
		tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
	}
}
#calculate by pressing Enter
bind .main.mitte.rechts.e_tau_exc <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sum]?$} $tau_exc] || $tau_exc == ""} {
		set colortau1 black
		redraw .main.bild $installdir
		if {[regexp {[s]$} $tau_exc]} {
			set tau_exc [format %%f [string trimright $tau_exc {s}]]
		} elseif {[regexp {[m]$} $tau_exc]} {
			set tau_exc [format %%f [expr [format %%.1f [string trimright $tau_exc {m}]]/1000]]
		} elseif {[regexp {[u]$} $tau_exc]} {
			set tau_exc [format %%f [expr [format %%.1f [string trimright $tau_exc {u}]]/1000000]]
		}
		if {$tau_exc == 0} {
			set tau_exc ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
		.main.unten.b_Berechnen invoke
		continue
	} else {
		set tau_exc ""
		tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
		break
	}
}

#creating button field

button .main.unten.b_Berechnen -text "$textpart(21)" -padx 2 -command {
	if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} $tau] || $tau == ""} {
		if {[regexp {[s]$} $tau]} {
			set tau [format %f [string trimright $tau {s}]]
		} elseif {[regexp {[m]$} $tau]} {
			set tau [format %f [expr [format %.1f [string trimright $tau {m}]]/1000]]
		} elseif {[regexp {[u]$} $tau]} {
			set tau [format %f [expr [format %.1f [string trimright $tau {u}]]/1000000]]
		}
		if {$tau == 0} {
			set tau ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
	} else {
			set tau ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
	}
	if {[regexp {^[0-9]*\.?[0-9]+[sum]?$} $tau_exc] || $tau_exc == ""} {
		if {[regexp {[s]$} $tau_exc]} {
			set tau_exc [format %f [string trimright $tau_exc {s}]]
		} elseif {[regexp {[m]$} $tau_exc]} {
			set tau_exc [format %f [expr [format %.1f [string trimright $tau_exc {m}]]/1000]]
		} elseif {[regexp {[u]$} $tau_exc]} {
			set tau_exc [format %f [expr [format %.1f [string trimright $tau_exc {u}]]/1000000]]
		}
		if {$tau_exc == 0} {
			set tau_exc ""
			tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
			break
		}
	} else {
		set tau_exc ""
		tk_messageBox -message "$textpart(19)" -title "$textpart(20)" -type ok
		break
	}
	if {$fehler_depha == ""} {
		set fehler_depha 0.0
	}
	set GesErgebnis [Berechnen $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha $Ergebnis]
	if {[lindex $GesErgebnis 0] != "$textpart(22)" && [lindex $GesErgebnis 0] != "" } {
		set Ergebnis [format %.3f [lindex $GesErgebnis 0]]
	} else {
		set Ergebnis "$textpart(22)"
	}
	if {[lindex $GesErgebnis 1] != ""} {
		set Fehler [format %.2f [lindex $GesErgebnis 1]]
	}
	if {[lindex $GesErgebnis 2] != ""} {
		set nue_dip_max [format %.2f [lindex $GesErgebnis 2]]
	}
	if {[lindex $GesErgebnis 3] != ""} {
		set depha [format %.2f [lindex $GesErgebnis 3]]
	}
}
button .main.unten.b_plot -text "$textpart(23)" -padx 2 -command {
	.mbar.plot.menu invoke 0
}
bind .main.unten.b_plot <KeyPress-Return> {

	.mbar.plot.menu invoke 0
}
button .main.unten.b_help -text "$textpart(24)" -padx 2 -command {
	invokebrowser file://$installdir/dipolcalculator_help/index.html $platform
}
bind .main.unten.b_help <KeyPress-Return> {
	.main.unten.b_help invoke
}
#bindings for the button field
bind .main.unten.b_Berechnen <KeyPress-Return> {
	.main.unten.b_Berechnen invoke
}
pack .main.unten.b_Berechnen .main.unten.b_plot .main.unten.b_help -side right
#############################################################################################################
#creating menu bar
#############################################################################################################


menubutton .mbar.file -text "File" -underline 0 -menu .mbar.file.menu

#############################################################################################################
#1) File menu
#############################################################################################################
menu .mbar.file.menu -tearoff 0
#############################################################################################################
#creating inputfile menu and the evaluation of the input file
#############################################################################################################

	.mbar.file.menu add command -label "$textpart(25)" -underline 0 -command {
		#create new window toplevel
		if { [ winfo exists .inputfile] } {
			destroy .inputfile
		}
		toplevel .inputfile
		wm title .inputfile "$textpart(26)"
		#split toplevel

		#label part and entry part
		frame .inputfile.oben -bd 2

		#button part
		frame .inputfile.unten -bd 2
		pack .inputfile.oben .inputfile.unten -side top

		#creating label ane entr part
		label .inputfile.oben.l_filepath -text "$textpart(27)"
		entry .inputfile.oben.e_filepath -width 20 -textvariable filename
		label .inputfile.oben.l_text -wraplength 350 -text "$textpart(28)"
		pack .inputfile.oben.l_text
		pack .inputfile.oben.l_filepath .inputfile.oben.e_filepath -side left
		bind .inputfile.oben.e_filepath <KeyPress-Return> {.inputfile.unten.b_ok invoke}
		focus .inputfile.oben.e_filepath
		#creating button ppart
		button .inputfile.unten.b_browse -text "$textpart(29)" -command {
		set filename [tk_getOpenFile]
		if {$filename == ""} {destroy .inputfile
		} else { 
			focus .inputfile.unten.b_ok
			.inputfile.unten.b_ok invoke
		}
		}
		button .inputfile.unten.help -text "$textpart(30)" -command {
			invokebrowser "file://$installdir/dipolcalculator_help/index.html" $platform
		}
		button .inputfile.unten.b_ok -text "$textpart(31)" -command {
			#read input file
			if {[file exists $filename] == 1} {
				destroy .inputfile
				wm title . "$textpart(121)"
				if { [ winfo exists .calc] } {
					destroy .calc
				}
				toplevel .calc 
				wm title .calc "$textpart(121)"
				label .calc.l -text "$textpart(120)"
				pack .calc.l
				focus .calc.l
				wm transient .calc .
				update idletasks
				# open output file
				set output [open [file rootname $filename].out w]
				set inhalt 0
				set input [open $filename r]
				while {[gets $input Zeile] >= 0} {
					if { [regexp ^\#\!.*$ $Zeile]} {
						if {[llength $Zeile] == 3} {
							set pulsesym [lindex $Zeile 1]
							if {[lindex $Zeile 2] == "inadequate" } {
								set Funktionsname funktioninadequate
							} elseif {[lindex $Zeile 2] == "postc7" } {
								set Funktionsname funktionpostc7
							} else {
								tk_messageBox -message "$textpart(65)" -title "$textpart(20)" -type ok
								destroy .inputfile
								break
							}
						}
						if {[llength $Zeile] == 2 && [regexp C [lindex $Zeile 1]]  && $Funktionsname != "" || [regexp R [lindex $Zeile 1]]} {
							set pulsesym [lindex $Zeile 1]
						} elseif {[llength $Zeile] == 2 && [regexp C [lindex $Zeile 1]]  && $Funktionsname == "" || [regexp R [lindex $Zeile 1]]} {
							tk_messageBox -message "$textpart(65)" -title "$textpart(20)" -type ok
							destroy .inputfile
							break
						}
						if {[llength $Zeile] == 2 && [regexp t [lindex $Zeile 1]] && $kappa != ""} {
							if {[lindex $Zeile 1] == "inadequate" } {
								set Funktionsname funktioninadequate
							} elseif {[lindex $Zeile 1] == "postc7" } {
								set Funktionsname funktionpostc7
							}
							set pulsesym [.main.oben2.buttonframe.mid.l_short3 cget -text]
						} elseif {[llength $Zeile] == 2 && $kappa == ""} {
							tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
							destroy .inputfile
							break
						}
						if {[llength $Zeile] == 1 && $kappa != "" && $Funktionsname != ""} {
							set pulsesym [.main.oben2.buttonframe.mid.l_short3 cget -text]
						} elseif {[llength $Zeile] == 1 && $kappa == "" && $Funktionsname == ""} {
							tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
							destroy .inputfile
							break
						}
						
						pack forget .main.mitte.links.l_tau_exc
						pack forget .main.mitte.rechts.e_tau_exc
						foreach Element [winfo children .main.bild] {
							pack forget $Element
						}
						pack .main.bild.$Funktionsname -anchor center -fill x -fill y
						.main.oben2.buttonframe.mid.l_short3 configure -text "$pulsesym"
						set sym [lindex [split $pulsesym -] 0]
						set arrayindex [lrange [split $pulsesym -] 1 end]
						set arraytype [lrange [split $pulsesym -] 0 0]
						if {$arraytype == "C"} {
							set kappa $CSequenz([lindex $arrayindex 0],[expr ([lindex $arrayindex 1]-1)+3+[lindex $arrayindex 2]])
						} elseif {$arraytype == "R"} {
							set kappa $RSequenz([lindex $arrayindex 0],[expr ([lindex $arrayindex 1]-1)+3+[lindex $arrayindex 2]])
						} 
						puts $output "# kappa \t pulsesequence symmetry \t excitation via"
						puts $output "#! $kappa \t $pulsesym \t $Funktionsname"
						if { $Funktionsname == "funktioninadequate"} {
							puts $output "#dephasing time \[s\] \t dephasing ratio \t error dephasing ratio \t nu_dip \t error \
							\t nu_dip max"
						} elseif { $Funktionsname == "funktionpostc7"} {
							puts $output "#dephasing time \[s\] \t exciation time \[s\] \t dephasing ratio \t error dephasing ratio \t nu_dip \t error \
							\t nu_dip max"
						}
						continue
					}
					# row wise  evaluation
					if {[regexp ^\# $Zeile] || $Zeile == ""} {
						continue
						# exclude commend rows
					}
					# split input row and evaluate each line
					if { $Funktionsname == "funktioninadequate" && [llength $Zeile] == 3 || $Funktionsname == "funktioninadequate" && [llength $Zeile] == 2} {
						set depha ""
						set fehler_depha ""
						set tau ""
						set tau_exc ""
						if {[llength $Zeile] < 2 || [llength $Zeile] > 3 } {
							tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
							destroy .inputfile
							break
						}
						if {[llength $Zeile] == 3 } {
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 1]]} {
								set depha [lindex $Zeile 1]
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 0]] || [lindex $Zeile 0] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 0]]} {
									set tau [format %f [string trimright [lindex $Zeile 0] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {u}]]/1000000]]
								} else {
									set tau [lindex $Zeile 0]
								}
								if {$tau == 0} {
									set tau ""
								}
							}
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 2]]} {
								set fehler_depha [lindex $Zeile 2]
							}
						}
						if {[llength $Zeile] == 2 } {
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 1]]} {
								set depha [lindex $Zeile 1]
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 0]] || [lindex $Zeile 0] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 0]]} {
									set tau [format %f [string trimright [lindex $Zeile 0] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {u}]]/1000000]]
								} else {
									set tau [lindex $Zeile 0]
								}
								if {$tau == 0} {
									set tau ""
								}
							}
								set fehler_depha 0.0
						}
						incr inhalt 1
						set GesErgebnis [Berechneninput $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha $output]
						puts "$GesErgebnis "
						if {[lindex $GesErgebnis 0] != "$textpart(22)" && [lindex $GesErgebnis 0] != ""} {
							set Ergebnis [format %.2f [lindex $GesErgebnis 0]]
						} elseif {[lindex $GesErgebnis 0] == "$textpart(22)"} {
							set Ergebnis "n.a."
						}
						if {[lindex $GesErgebnis 1] != ""} {
							set Fehler [format %.2f [lindex $GesErgebnis 1]]
						}
						if {[lindex $GesErgebnis 2] != ""} {
							set nue_dip_max [format %.2f [lindex $GesErgebnis 2]]
						}
						if {[lindex $GesErgebnis 3] != ""} {
							set depha [format %.2f [lindex $GesErgebnis 3]]
						}
						if {$Ergebnis != "$textpart(22)"} {
							puts $output "$tau \t $tau_exc \t $depha \t $fehler_depha \t $Ergebnis \t $Fehler\
							\t $nue_dip_max"
						} elseif  {$Ergebnis != "n.a."} {
							puts $output "$tau \t $tau_exc \t $depha \t $fehler_depha \t $Ergebnis"
						} else {
							puts $output "#$textpart(33)"
						}
					} elseif {$Funktionsname == "funktionpostc7" && [llength $Zeile] == 3 || $Funktionsname == "funktionpostc7" &&  [llength $Zeile] == 4} {
						incr inhalt 1
						set depha ""
						set fehler_depha ""
						set tau ""
						set tau_exc ""
						if {[llength $Zeile] <= 2 || [llength $Zeile] >= 5} {
							tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
							destroy .inputfile
							break
						}
						if {[llength $Zeile] == 4 } {
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 2]]} {
								set depha [lindex $Zeile 2]
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 0]] || [lindex $Zeile 0] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 0]]} {
									set tau [format %f [string trimright [lindex $Zeile 0] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {u}]]/1000000]]
								} else {
									set tau [lindex $Zeile 0]
								}
								if {$tau == 0} {
									set tau ""
								}
								
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 1]] || [lindex $Zeile 1] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [string trimright [lindex $Zeile 1] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [expr [format %.1f [string trimright [lindex $Zeile 1] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [expr [format %.1f [string trimright [lindex $Zeile 1] {u}]]/1000000]]
								} else {
									set tau_exc [lindex $Zeile 1]
								}
								if {$tau_exc == 0} {
									set tau_exc ""
								}
							}
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 3]]} {
								set fehler_depha [lindex $Zeile 3]
							}
						}
						if {[llength $Zeile] == 3 } {
							if {[regexp {^[0-9]*\.?[0-9]+$} [lindex $Zeile 2]]} {
								set depha [lindex $Zeile 2]
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 1]] || [lindex $Zeile 0] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 0]]} {
									set tau [format %f [string trimright [lindex $Zeile 0] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 0]]} {
									set tau [format %f [expr [format %.1f [string trimright [lindex $Zeile 0] {u}]]/1000000]]
								} else {
									set tau [lindex $Zeile 0]
								}
								if {$tau == 0} {
									set tau ""
								}
							}
							if {[regexp {^[0-9]*\.?[0-9]+[smu]?$} [lindex $Zeile 2]] || [lindex $Zeile 1] == ""} {
								if {[regexp {[s]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [string trimright [lindex $Zeile 1] {s}]]
								} elseif {[regexp {[m]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [expr [format %.1f [string trimright [lindex $Zeile 1] {m}]]/1000]]
								} elseif {[regexp {[u]$} [lindex $Zeile 1]]} {
									set tau_exc [format %f [expr [format %.1f [string trimright [lindex $Zeile 1] {u}]]/1000000]]
								} else {
									set tau_exc [lindex $Zeile 1]
								}
								if {$tau_exc == 0} {
									set tau_exc ""
								}
							}
								set fehler_depha 0.0
						}
						if {$depha <= 1} {
							set GesErgebnis [Berechneninput $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha $output]
							if {[lindex $GesErgebnis 0] != "$textpart(22)" && [lindex $GesErgebnis 0] != ""} {
								set Ergebnis [format %.2f [lindex $GesErgebnis 0]]
							} elseif {[lindex $GesErgebnis 0] == "$textpart(22)"} {
								set Ergebnis "n.a."
							}
							if {[lindex $GesErgebnis 1] != ""} {
								set Fehler [format %.2f [lindex $GesErgebnis 1]]
							}
							if {[lindex $GesErgebnis 2] != ""} {
								set nue_dip_max [format %.2f [lindex $GesErgebnis 2]]
							}
							if {[lindex $GesErgebnis 3] != ""} {
								set depha [format %.2f [lindex $GesErgebnis 3]]
							}
						} else {
								set Ergebnis "n.a."
						}
						if {$Ergebnis != "$textpart(22)"} {
							puts $output "$tau \t $tau_exc \t $depha \t $fehler_depha \t $Ergebnis \t $Fehler\
							\t $nue_dip_max"
						} elseif  {$Ergebnis != "n.a."} {
							puts $output "$tau \t $tau_exc \t $depha \t $fehler_depha \t $Ergebnis"
						} else {
							puts $output "#$textpart(33)"
						}
					} else {
						puts $output "#$textpart(33)"
					}
					flush $output

				} 
				close $input
				close $output
				wm title . "$textpart(1)"
				destroy .calc
				update idletasks
				tk_messageBox -message "$textpart(35) [file rootname $filename].out" -title "$textpart(20)" -type ok
			} else {
				tk_messageBox -message "$textpart(36)" -title "$textpart(20)" -type ok
				return 0
				break
			}
			if {$inhalt == 0} {
				tk_messageBox -message "$textpart(37)" -title "$textpart(20)" -type ok
				return 0
				break
			}
		}

		pack .inputfile.unten.help .inputfile.unten.b_browse .inputfile.unten.b_ok -side left
}
#creating calculate button

	.mbar.file.menu add command -label "$textpart(21)" -underline 0 -command {
		.main.unten.b_Berechnen invoke
	}
#sart wizard
	.mbar.file.menu add command -label "$textpart(38)" -underline 0 -command {
	source $installdir/wizard.tcl
	}

#creating exit button

	.mbar.file.menu add command -label "$textpart(39)" -underline 0 -command exit

#############################################################################################################
#2) Plot menu
#############################################################################################################

menubutton .mbar.plot -text "$textpart(40)" -underline 0 -menu .mbar.plot.menu
pack .mbar.file .mbar.plot -side left

#create nenue Plot

menu .mbar.plot.menu -tearoff 0
	#Plot Graph menu (plot actual graph and actual point) and export to eps function
	.mbar.plot.menu add command -label "$textpart(23)" -underline 5 -command {
		destroy .graph
		set point 0
		if {[regexp {^[0-9]*\.?[0-9]+$} $tau_exc] || $tau_exc=="" && [regexp {^[0-9]*\.?[0-9]+$} $tau] && [regexp {^[0-9]*\.?[0-9]+$} $kappa] && $Funktionsname != ""\
		&& [regexp {^-[0-9]*\.?[0-9]+$} $nue_dip_max] && [regexp {^-[0-9]*\.?[0-9]+$} $Ergebnis]} {
			#create toplevel Graph
			if { [ winfo exists .graph] } {
					destroy .graph
				}
			toplevel .graph
			wm title .graph "$textpart(41)."
			#split toptlevel
			frame .graph.plotarea
			frame .graph.buttons
			#create Graph of the acual function
			blt::graph .graph.plotarea.graph1
			bind .graph.plotarea.graph1 <ButtonPress-1> { RegionStart %W %x %y }
			bind .graph.plotarea.graph1 <B1-Motion> { RegionMotion %W %x %y }
			bind .graph.plotarea.graph1 <ButtonRelease-1> { RegionEnd %W %x %y }
			bind .graph.plotarea.graph1 <ButtonRelease-3> { Unzoom %W }
			bind .graph.plotarea.graph1 <Double-ButtonPress-1> {punkt %W %x %y}
			if {[plotfunction  $Funktionsname "$kappa $tau $tau_exc" 1 1 0]=="$textpart(22)" && [plotfunction  $Funktionsname "$kappa $tau $tau_exc" [expr (abs($nue_dip_max) + 100) / 10] 1 0]} {
				destroy .graph
				return 0
			}
			#plot actual function
			if {$Funktionsname=="funktioninadequate"} {
				set intervall [expr (abs($nue_dip_max) + 200) / 100]
				set steps [expr (abs($nue_dip_max) + 200) / $intervall]
			} elseif {$Funktionsname=="funktionpostc7"} {
				set intervall [expr (abs($nue_dip_max) + 200) / 100 * 2]
				set steps [expr (abs($nue_dip_max) + 200) / $intervall]
			} else { tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
				return 0}
			set value [plotfunction  $Funktionsname "$kappa $tau $tau_exc" 1 $steps $intervall]

			.graph.plotarea.graph1 element create line0 -symbol "" -xdata [lindex $value 0] -ydata [lindex $value 1]
			#modify graph apearence
			.graph.plotarea.graph1 element configure line0 -label ""
			.graph.plotarea.graph1 axis configure x -title "$textpart(42)"
			.graph.plotarea.graph1 axis configure y -title "$textpart(43)"
			#plot actual point
			button .graph.buttons.b_point -text "$textpart(44)" -command {
				if {[regexp {^[0-9]*\.?[0-9]+$} $tau_exc] || $tau_exc=="" && [regexp {^[0-9]*\.?[0-9]+$} $tau] && [regexp {^[0-9]*\.?[0-9]+$} $kappa] && $Funktionsname != ""\
				&& [regexp {^-[0-9]*\.?[0-9]+$} $nue_dip_max] && [regexp {^-[0-9]*\.?[0-9]+$} $Ergebnis]  && [regexp {^[0-9]*\.?[0-9]+$} $Fehler]} {
					set color "0 yellow blue green red"
					incr point 1
					set value2($point) [plotfunction  $Funktionsname "$kappa $tau $tau_exc" $Ergebnis 0 0]
					set xhigh($point) [expr [lindex $value2($point) 0]+$Fehler]
					set xlow($point)  [expr [lindex $value2($point) 0]-$Fehler]
					#plot actual point with errorbar
					.graph.plotarea.graph1 element create line$point -symbol cross -fill [lindex $color $point]\
					  -errorbarwidth 2 -xdata [lindex $value2($point) 0] -ydata [lindex $value2($point) 1]\
					  -xhigh $xhigh($point) -xlow $xlow($point)
					.graph.plotarea.graph1 element configure line$point -label "Point $point"
					set x1 [lindex $value2($point) 0]
					set y1 [lindex $value2($point) 1]
					.graph.plotarea.graph1 marker create line -coords { $x1 $y1 $x1 -Inf }
					.graph.plotarea.graph1 marker create line -coords { $x1 $y1 0 $y1 }
				} else {
					tk_messageBox -message "$textpart(45)" -title "$textpart(20)" -type ok
					return 0
				}
			}
			# EPS export
			button .graph.buttons.help -text "$textpart(30)" -command {
				invokebrowser "file://$installdir/dipolcalculator_help/index.html" $platform
			}
			button .graph.buttons.print -text "$textpart(46)" -command {
				if { [ winfo exists .printplot] } {
					destroy .printplot
				}
				toplevel .printplot
				wm title .printplot "$textpart(46)"
				#Toplevel aufteilen

				#Eingabefeld aufbauen
				frame .printplot.oben -bd 2

				#Buttonleiste aufbauen
				frame .printplot.unten -bd 2
				pack .printplot.oben .printplot.unten -side top

				#Eingabefeld belegen
				label .printplot.oben.l_filepath -text "$textpart(47)"
				entry .printplot.oben.e_filepath -width 20 -textvariable plotdir
				pack .printplot.oben.l_filepath .printplot.oben.e_filepath -side left
				bind .printplot.oben.e_filepath <KeyPress-Return> {.printplot.unten.b_ok invoke}
				focus .printplot.oben.e_filepath
				#Buttonleiste belegeb
				
				button .printplot.unten.b_ok -text "Ok" -command {
					#export to EPS
					.graph.plotarea.graph1 postscript output $plotdir
					destroy .printplot
					tk_messageBox -message "$textpart(48) $plotdir " -title "$textpart(20)" -type ok
				}
				pack .printplot.unten.b_ok 

			}


			pack .graph.plotarea .graph.buttons -side top
			pack .graph.plotarea.graph1
			pack .graph.buttons.b_point .graph.buttons.print .graph.buttons.help -side right
		} else {
			tk_messageBox -message "$textpart(45)" -title "$textpart(20)" -type ok
			return 0
		}
	}
	# plot the results of the outputfile
	.mbar.plot.menu add command -label "$textpart(49)" -underline 0 -command {
		set filename "[file rootname $filename].out"
		#create new toplevel to get outputfile
		if { [ winfo exists .plotout] } {
			destroy .plotout
		}
		toplevel .plotout
		wm title .plotout "$textpart(50)"
		#split toplevel
		frame .plotout.text2
		frame .plotout.text
		frame .plotout.button
		pack .plotout.text2 .plotout.text .plotout.button -side top
		#build textarea
		label .plotout.text2.l_text -wraplength 350 -text "$textpart(51)"
		pack .plotout.text2.l_text
		label .plotout.text.l_filepath -text "$textpart(53)"
		entry .plotout.text.e_filepath -width 20 -textvariable filename
		pack .plotout.text.l_filepath .plotout.text.e_filepath -side left
		bind .plotout.text.e_filepath <KeyPress-Return> {.plotout.button.b_ok invoke}
		focus .plotout.text.e_filepath
		#create button field
		button .plotout.button.help -text "$textpart(24)" -command {
			invokebrowser "file://$installdir/dipolcalculator_help/index.html" $platform
		}
		button .plotout.button.b_browse -text "$textpart(29)" -command {
				set filename [tk_getOpenFile]
				if {$filename == ""} {destroy .plotout
				} else { 
					focus .plotout.button.b_ok
					.plotout.button.b_ok invoke
				}
				}
		button .plotout.button.b_ok -text "$textpart(31)" -command {
			destroy .plotout
			plotoutput $filename $installdir $Browser $platform
		}
		pack .plotout.button.help .plotout.button.b_browse .plotout.button.b_ok -side left
	}
#############################################################################################################
#3) Help menu
#############################################################################################################

menubutton .mbar.help -text "$textpart(30)" -menu .mbar.help.menue -underline 0
pack .mbar.help -side right

menu .mbar.help.menue -tearoff 0

	.mbar.help.menue add command -label "$textpart(52)" -command {
		invokebrowser "file://$installdir/dipolcalculator_help/index.html" $platform
	
	}

tk_menuBar .mbar .mbar.file .mbar.plot .mbar.help
#focus .mbar
#starting menu fiel
if {$startup == "yes"} {
	source $installdir/wizard.tcl
	raise  . .wizard
	wm transient .wizard .
	update idletasks
}


