#! /usr/bin/wish
if { [lindex $argv 0] == "yes" } {
	set startup yes
} elseif { [lindex $argv 0] == "no" } {
	set startup no
} elseif { [lindex $argv 0] == "" } {
	set startup yes
} else {
	set startup ""
}
if { [lindex $argv 1] != "" } {
	set installdir [lindex $argv 1]
} else {set installdir [pwd]}
proc browserlinux { } {
        foreach browser {firefox htmlview mozilla konqueror netscape} {
            set binary [lindex [auto_execok $browser] 0]
            if {[string length $binary]} {
    		return $binary
                break
            }
        }
    }

set platform $tcl_platform(os)
if {[regexp {^Linux*} $platform]} {
	set Browser "[browserlinux]"
	set datei "$env(HOME)/.DoDeCalculator"
} elseif {[regexp {^Windows NT*} $platform]} {
	set Browser "\$env(COMSPEC) /c start"
	set datei "$env(HOME)/DoDeCalculator.init"
} elseif {[regexp {^Windows 95\/98*} $platform]} {
	set Browser "start"
	set datei "$env(HOME)/DoDeCalculator.init"
}
proc runall { } {
	global startup installdir Browser language datei platform
	set Zeilenzahl 1
	if {[file exists $datei] == 1} {
		set Dateiw [open "$datei" w]
		puts $Dateiw "set startup \"$startup\""
		puts $Dateiw "set installdir \"$installdir\""
		puts $Dateiw "set Browser \"$Browser\""
		if  {[regexp {^Windows*} $platform]} {
				puts $Dateiw "set mendat \"$installdir/menseq_win.tcl\""
			} else {
				puts $Dateiw "set mendat \"$installdir/menseq_unix.tcl\""
			}
		puts $Dateiw "set language $language"
		close $Dateiw
	} else {
		set Dateiw [open "$datei" w]
		puts $Dateiw "set startup \"$startup\""
		puts $Dateiw "set installdir \"$installdir\""
		puts $Dateiw "set Browser \"$Browser\""
		if  {[regexp {^Windows*} $platform]} {
				puts $Dateiw "set mendat \"$installdir/menseq_win.tcl\""
			} else {
				puts $Dateiw "set mendat \"$installdir/menseq_unix.tcl\""
			}
		puts $Dateiw "set language $language"
		close $Dateiw
	}	

	exit
} 
frame .oben
frame .unten
pack .oben .unten -side top
label .oben.l -text "Choose a language."
pack .oben.l
button .unten.eng -text "English" -command {
	set language english
	runall
}
button .unten.ge -text "Deutsch" -command {
	set language german
	runall
}

pack .unten.eng .unten.ge -side left
