########################################################################################################################
#general  procedures
########################################################################################################################

# integral --
#    Integrate a function over a given interval using the Simpson rule
#
# Arguments:
#    begin       Start of the interval
#    end         End of the interval
#    nosteps     Number of steps in which to divide the interval
#    func        Name of the function to be integrated (takes one
#                argument)
# Return value:
#    Computed integral
#
proc integral { begin end nosteps func } {

   set delta    [expr {($end-$begin)/double($nosteps)}]
   set hdelta   [expr {$delta/2.0}]
   set result   0.0
   set xval     $begin
   set func_end [uplevel 1 $func $xval]
   for { set i 1 } { $i <= $nosteps } { incr i } {
      set func_begin  $func_end
      set func_middle [uplevel 1 $func [expr {$xval+$hdelta}]]
      set func_end    [uplevel 1 $func [expr {$xval+$delta}]]
      set result      [expr  {$result+$func_begin+4.0*$func_middle+$func_end}]

      set xval        [expr {$begin+double($i)*$delta}]
   }

   return [expr {$result*$delta/6.0}]
}



# Function for the Inadequate-pulse-seqence
# Variables: List with three elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: nu_dip
# return value: Ergebniss = result
proc funktioninadequate {Variablen} {
	global textpart
	if { [llength $Variablen] == 3 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr 1-5.92176*(pow($kappa*$nu_dip*$tau,2.0))\
     			+10.8542*(pow($kappa*$nu_dip*$tau,4.0))\
    			+66.0045*(pow($kappa*$nu_dip*$tau,6.0))\
    			+75.7769*(pow($kappa*$nu_dip*$tau,8.0))\
      			-257.0597*(pow($kappa*$nu_dip*$tau,10.0))\
   			-1042.1838*(pow($kappa*$nu_dip*$tau,12.0))\
       			]

		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}
}


# Function for the derivation of the  Inadequate-pulse-seqence
# Variables: List with three elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: nu_dip
# return value: Ergebniss = result
proc derv_funktioninadequate {Variablen} {
	global textpart
	if { [llength $Variablen] == 3 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr -5.92176*(pow($kappa*$tau,2.0))*2.0*$nu_dip\
     			+10.8542*(pow($kappa*$tau,4.0))*4.0*(pow($nu_dip,3.0))\
    			+66.0045*(pow($kappa*$tau,6.0))*6.0*(pow($nu_dip,5.0))\
    			+75.7769*(pow($kappa*$tau,8.0))*8.0*(pow($nu_dip,7.0))\
      			-257.0597*(pow($kappa*$tau,10.0))*10.0*(pow($nu_dip,9.0))\
   			-1042.1838*(pow($kappa*$tau,12.0))*12.0*(pow($nu_dip,11.0))\
       			]

		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}
}


#nomenator for the exact post C7 funktion
proc DQfunctionnom {x} {
global pi
upvar kappa kappa nu_dip nu_dip tau tau tau_exc tau_exc
return [expr (0.5+0.5*cos(3.0*$kappa*$nu_dip*$pi*$tau*sin(2.0*$x)))*sin($x)*\
pow(sin(3.0*$kappa*$nu_dip*$pi*$tau_exc*sin(2.0*$x)),2.0)]
}


#denomenator for the exact post C7 funktion
proc DQfunctiondenom {x} {
	global pi
	upvar kappa kappa nu_dip nu_dip tau tau tau_exc tau_exc
	return [expr pow((0.5+0.5*cos(3.0/2.0*$kappa*$nu_dip*$pi*$tau*sin(2.0*$x))),2.0)*sin($x)*\
		pow(sin(3.0*$kappa*$nu_dip*$pi*$tau_exc*sin(2.0*$x)),2.0)]
}


#integration in the exact post C7 funktion
proc dephasing {kappa tau tau_exc nu_dip} {
	global pi
	set steps 200
	return [expr [integral 0.0 $pi $steps DQfunctionnom]/[integral 0.0 $pi $steps DQfunctiondenom]]
}

# Function for the derivation of the exact PostC7-pulse-seqence
proc derv {kappa tau tau_exc nu_dip } {
	global pi
	set steps 200
	set nu_dipold $nu_dip
	set nu_dip [expr $nu_dipold+0.5]
	set obergrenze [dephasing $kappa $tau $tau_exc $nu_dip]
	set nu_dip [expr $nu_dipold-0.5]
	set untergrenze [dephasing $kappa $tau $tau_exc $nu_dip]
	set nu_dip $nu_dipold
	set ergebnis [expr $obergrenze-$untergrenze]
	return $ergebnis
}


# Function for the exakt PostC7-pulse-seqence
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result

proc funktionpostc7 {Variablen} {
	global textpart pi
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr [dephasing $kappa $tau $tau_exc $nu_dip]]
		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}

# Function for the derivation of the PostC7-pulse-seqence
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result

proc derv_funktionpostc7 {Variablen} {
	global textpart
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [derv  $kappa $tau $tau_exc $nu_dip]
		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}

# Referenz for the Function for the exakt PostC7-pulse-seqence
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result


proc funktionpostc7_ref {Variablen} {
	global textpart pi
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr [dephasing $kappa $tau $tau_exc $nu_dip]]
		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}


# Function for the derivation of the PostC7-pulse-seqence
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result

proc derv_funktionpostc7_ref {Variablen} {
	global textpart
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [derv  $kappa $tau $tau_exc $nu_dip]
		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}

# Function for the PostC7-pulse-seqence
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result

proc funktionpostc7_expansion {Variablen} {
	global textpart
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr 1-8.45966*(pow($kappa*$nu_dip*$tau,2.0))\
			+0.688133*(pow($kappa*$nu_dip*$tau,4.0))\
  	 		+82.9188*(pow($kappa*$nu_dip*$tau,6.0))\
 	    		+356.496*(pow($kappa*$nu_dip*$tau,8.0))\
 	      		+917.248*(pow($kappa*$nu_dip*$tau,10.0))\
  	     		+19.3511*(pow($kappa,4.0)*pow($nu_dip,4.0)*pow($tau,2.0)*pow($tau_exc,2.0))\
 	      		+78.1164*(pow($kappa,6.0)*pow($nu_dip,6.0)*pow($tau,4.0)*pow($tau_exc,2.0))\
  	     		-112.42*(pow($kappa,8.0)*pow($nu_dip,8.0)*pow($tau,6.0)*pow($tau_exc,2.0))\
 	      		-2436.81*(pow($kappa,10.0)*pow($nu_dip,10.0)*pow($tau,8.0)*pow($tau_exc,2.0))\
      			-13453.3*(pow($kappa,12.0)*pow($nu_dip,12.0)*pow($tau,10.0)*pow($tau_exc,2.0))\
 	      		+146.459*(pow($kappa,6.0)*pow($nu_dip,6.0)*pow($tau,2.0)*pow($tau_exc,4.0))\
       			+361.662*(pow($kappa,8.0)*pow($nu_dip,8.0)*pow($tau,4.0)*pow($tau_exc,4.0))\
 	      		-2364.13*(pow($kappa,10.0)*pow($nu_dip,10.0)*pow($tau,6.0)*pow($tau_exc,4.0))\
       			-19351.1*(pow($kappa,12.0)*pow($nu_dip,12.0)*pow($tau,8.0)*pow($tau_exc,4.0))\
       			-59052.6*(pow($kappa,14.0)*pow($nu_dip,14.0)*pow($tau,10.0)*pow($tau_exc,4.0))\
       			+912.66*(pow($kappa,8.0)*pow($nu_dip,8.0)*pow($tau,2.0)*pow($tau_exc,6.0))\
       			-339.254*(pow($kappa,10.0)*pow($nu_dip,10.0)*pow($tau,4.0)*pow($tau_exc,6.0))\
       			-28544.7*(pow($kappa,12.0)*pow($nu_dip,12.0)*pow($tau,6.0)*pow($tau_exc,6.0))\
       			-106658.0*(pow($kappa,14.0)*pow($nu_dip,14.0)*pow($tau,8.0)*pow($tau_exc,6.0))\
       			+112723.0*(pow($kappa,16.0)*pow($nu_dip,16.0)*pow($tau,10.0)*pow($tau_exc,6.0))\
       			+4205.54*(pow($kappa,10.0)*pow($nu_dip,10.0)*pow($tau,2.0)*pow($tau_exc,8.0))\
       			-26880.1*(pow($kappa,12.0)*pow($nu_dip,12.0)*pow($tau,4.0)*pow($tau_exc,8.0))\
       			-224842.0*(pow($kappa,14.0)*pow($nu_dip,14.0)*pow($tau,6.0)*pow($tau_exc,8.0))\
       			-31429.2*(pow($kappa,16.0)*pow($nu_dip,16.0)*pow($tau,8.0)*pow($tau_exc,8.0))\
       			+5635312.6*(pow($kappa,18.0)*pow($nu_dip,18.0)*pow($tau,10.0)*pow($tau_exc,8.0))\
       			]

		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}


# Function for the derivation of the PostC7-pulse-seqence 
# Variables: List with four elements:
# 1 element: Kappa
# 2 element: Tau
# 3 element: Tau_exc
# 4 element: nu_dip
# return value: Ergebniss = result

proc derv_funktionpostc7_expansion {Variablen} {
	global textpart
	if { [llength $Variablen] == 4 } {
		set kappa [lindex $Variablen 0]
		set tau [lindex $Variablen 1]
		set tau_exc [lindex $Variablen 2]
		set nu_dip [lindex $Variablen end]
		set ergebnis [expr -8.45966*(pow($kappa*$tau,2.0))*2.0*$nu_dip\
			+0.688133*(pow($kappa*$tau,4.0))*4.0*(pow($nu_dip,3.0))\
  	 		+82.9188*(pow($kappa*$tau,6.0))*6.0*(pow($nu_dip,5.0))\
 	    		+356.496*(pow($kappa*$tau,8.0))*8.0*(pow($nu_dip,7.0))\
 	      		+917.248*(pow($kappa*$tau,10.0))*10.0*(pow($nu_dip,9.0))\
  	     		+19.3511*(pow($kappa,4.0)*4.0*pow($nu_dip,3.0)*pow($tau,2.0)*pow($tau_exc,2.0))\
 	      		+78.1164*(pow($kappa,6.0)*6.0*pow($nu_dip,5.0)*pow($tau,4.0)*pow($tau_exc,2.0))\
  	     		-112.42*(pow($kappa,8.0)*8.0*pow($nu_dip,7.0)*pow($tau,6.0)*pow($tau_exc,2.0))\
 	      		-2436.81*(pow($kappa,10.0)*10.0*pow($nu_dip,9.0)*pow($tau,8.0)*pow($tau_exc,2.0))\
      			-13453.3*(pow($kappa,12.0)*12.0*pow($nu_dip,11.0)*pow($tau,10.0)*pow($tau_exc,2.0))\
 	      		+146.459*(pow($kappa,6.0)*6.0*pow($nu_dip,5.0)*pow($tau,2.0)*pow($tau_exc,4.0))\
       			+361.662*(pow($kappa,8.0)*8.0*pow($nu_dip,7.0)*pow($tau,4.0)*pow($tau_exc,4.0))\
 	      		-2364.13*(pow($kappa,10.0)*10.0*pow($nu_dip,9.0)*pow($tau,6.0)*pow($tau_exc,4.0))\
       			-19351.1*(pow($kappa,12.0)*12.0*pow($nu_dip,11.0)*pow($tau,8.0)*pow($tau_exc,4.0))\
       			-59052.6*(pow($kappa,14.0)*14.0*pow($nu_dip,13.0)*pow($tau,10.0)*pow($tau_exc,4.0))\
       			+912.66*(pow($kappa,8.0)*8.0*pow($nu_dip,7.0)*pow($tau,2.0)*pow($tau_exc,6.0))\
       			-339.254*(pow($kappa,10.0)*10.0*pow($nu_dip,9.0)*pow($tau,4.0)*pow($tau_exc,6.0))\
       			-28544.7*(pow($kappa,12.0)*12.0*pow($nu_dip,11.0)*pow($tau,6.0)*pow($tau_exc,6.0))\
       			-106658.0*(pow($kappa,14.0)*14.0*pow($nu_dip,13.0)*pow($tau,8.0)*pow($tau_exc,6.0))\
       			+112723.0*(pow($kappa,16.0)*16.0*pow($nu_dip,15.0)*pow($tau,10.0)*pow($tau_exc,6.0))\
       			+4205.54*(pow($kappa,10.0)*10.0*pow($nu_dip,9.0)*pow($tau,2.0)*pow($tau_exc,8.0))\
       			-26880.1*(pow($kappa,12.0)*12.0*pow($nu_dip,11.0)*pow($tau,4.0)*pow($tau_exc,8.0))\
       			-224842.0*(pow($kappa,14.0)*14.0*pow($nu_dip,13.0)*pow($tau,6.0)*pow($tau_exc,8.0))\
       			-31429.2*(pow($kappa,16.0)*16.0*pow($nu_dip,15.0)*pow($tau,8.0)*pow($tau_exc,8.0))\
       			+5635312.6*(pow($kappa,18.0)*18.0*pow($nu_dip,17.0)*pow($tau,10.0)*pow($tau_exc,8.0))\
       			]

		return $ergebnis
	} else {
		tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		return "$textpart(22)"
	}

}



#replots the pulsesquenze ppicture
proc redraw {picture installdir} {
	global textpart
	global colortau2 colortau1 sym sym1 sym2 sym3 symnb_b symnbm1 symnbh_b symnbd_b unteneins untenzwei
	set actualpicture [pack slaves $picture]
		foreach Element [winfo children $picture] {
			destroy $Element
		}
		source $installdir/pulsinadequate.tk
		source $installdir/pulspc7.tk
		if {$actualpicture!=""} {
			pack $actualpicture
		}

}

#procedure to calculate x and y values to plot the functions
#requires name of the function (Function) the suitable variables (Functionvariabels) the starting point (start) numbers of steps (steps)
proc plotfunction {Function Functionvariabels start steps interval} {
	global textpart
	set x [expr abs($start)]
	set x_values {}
	set y_values {}
	set  Functionvariabels [lappend Functionvariabels $x]
	for {set i 0} {$i <= $steps} {incr i 1} {
		if {[$Function [lreplace $Functionvariabels end end $x]]=="$textpart(22)"} {
			return "$textpart(22)"
		}
		lappend x_values $x
		lappend y_values [$Function [lreplace $Functionvariabels end end $x]]
		set x [expr $x + $interval]
	}
	set Ergebnis "{$x_values} {$y_values}"
	return $Ergebnis
}



#procedure to calculate the error in the dephasingvalue
#requires Funktionsvariablen (Functionsname,variables,x-value),
#Intervallvariablen (upper border, lower border, given value)
#error iin the given value (fehler_depha)
proc Fehler {Funktionsvariablen fehler_depha Wert} {
	global textpart
	set Ergebnis [expr (($fehler_depha/[derv_[lindex $Funktionsvariablen 0] "[lrange $Funktionsvariablen 1 end] $Wert"])-\
	(-$fehler_depha/[derv_[lindex $Funktionsvariablen 0] "[lrange $Funktionsvariablen 1 end] $Wert"]))/2]
	return $Ergebnis
}

#procedure to search the null (or other values)
#requires two lists (Funktionsvar and Intervallvar)
#Funktionsvar: Functionsname Variable1 ... VariableN
#Intervallvar: lowerborder upperborder given value
proc intervallhalbierung {Funktionsvar Intervallvar} {
#split lists
	global textpart
	set Funktionsname [lindex $Funktionsvar 0]
	#functionsname
	set Funktionsvariablen [lrange $Funktionsvar 1 end]
	#Variables for the Function
	set intanfang [lindex $Intervallvar 0]
	#lower  border
	set intende [lindex $Intervallvar 1]
	#upper border
	set wert [lindex $Intervallvar 2]
	#given value
	set abbruch 1.0e-6
	# stop criterion
	set mitte [expr $intende-(($intende-$intanfang)/2)]
	#first split of the inervall
	set Funktionsvariablen [lappend Funktionsvariablen $mitte]
	set ergebnis [$Funktionsname $Funktionsvariablen]
	if {$ergebnis == "$textpart(22)"} {return $textpart(22)}
	#result afer the first splitting of the intervall
	set Funktionsvariablen [lreplace $Funktionsvariablen end end $intanfang]
	#Neuer x-Wert fuer die erste Referenz
	set referenz [$Funktionsname $Funktionsvariablen]
	#Referenz erzeugen
	set Schleife 0
	while { abs([expr $ergebnis-$wert]) > $abbruch } {
	#Schleife bis Abruchkriterium erreicht:
		if {[expr $wert-$ergebnis] <= 0 && [expr $wert-$referenz] < 0 || [expr $wert-$ergebnis] >= 0 && [expr $wert-$referenz] > 0} {
			#wenn  Referenz und Ergebnis groesser/kleiner als der vorgegebener-Wert sind:
			set referenz $ergebnis
			#Referen neu setzten
			set intanfang $mitte
			#Intervall neu setzten
			set mitte [expr $intende-(($intende-$intanfang)/2)]
			#neue Mitte errechnen
			set Funktionsvariablen [lreplace $Funktionsvariablen end end $mitte]
			#x-Wert neu setzten
			set ergebnis [$Funktionsname $Funktionsvariablen]
			#neues Ergebnis fuer den naechsten Durchgang
		} elseif {[expr $wert-$ergebnis] <= 0 && [expr $wert-$referenz] > 0 || [expr $wert-$ergebnis] >= 0 && [expr $wert-$referenz] < 0 } {
			#wenn  Referenz groesser/kleiner und Ergebnis kleiner/groesser als der vorgegebener-Wert sind:
			set intende $mitte
			#Intervall neu setzten; Referenz bleibt gleich!
			set mitte [expr $intende-(($intende-$intanfang)/2)]
			#neue Mitte errechnen
			set Funktionsvariablen [lreplace $Funktionsvariablen end end $mitte]
			#x-Wert neu setzten
			set ergebnis [$Funktionsname $Funktionsvariablen]
			#neues Ergebnis fuer den naechsten Durchgang
		}
		incr Schleife 1
		if {$Schleife >= 200 && $abbruch <= 1.0e-4} {
			set Schleife 0
			set abbruch [expr $abbruch * 10]
		} elseif {$Schleife >= 200 && $abbruch > 1.0e-4} {
			#tk_messageBox -message "$textpart(64) \[1 - [expr [format %.2f [$Funktionsname [lreplace $Funktionsvariablen end end [nue_dip_max $Funktionsvar]]]] + 0.01]\]" -title "$textpart(20)" -type ok
			return "$textpart(22)"
		}
	}
	return $mitte
	#return value: x-value which belong to th given value
}


#procedure which desides whether its a normal calculation or a reverse calculation
proc Berechnen {Funktionsname kappa tau tau_exc depha fehler_depha nue_dip} {
	global textpart
	#set kappa 0.1547667978024898
	if {$Funktionsname ==""} {
		tk_messageBox -message "$textpart(65)" -title "$textpart(20)" -type ok
		return 0
	}
	if {$Funktionsname == "funktioninadequate"} {
		if {[regexp {^[0-9]*\.?[0-9]+$} $kappa]} {
			set Ergebnis "$textpart(22)"
			if {$depha != "" && $tau != ""} {
				set Ergebnis [Normalberechnen $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha]
			} elseif {$tau != "" && $nue_dip != ""} {
				set Ergebnis [reversberechnen $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha $nue_dip]
		} else {
			tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
		}
		return $Ergebnis
		} elseif {$kappa == ""} {
			tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
			return 0
		}
	} elseif {$Funktionsname == "funktionpostc7"} {
		if {[regexp {^[0-9]*\.?[0-9]+$} $kappa]} {
			set Ergebnis "$textpart(22)"
			if {$depha != "" && $tau != "" && $tau_exc != ""} {
				set Ergebnis [Normalberechnen $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha]
			} elseif {$tau != "" && $tau_exc != "" && $nue_dip != ""} {
				set Ergebnis [reversberechnen $Funktionsname $kappa $tau $tau_exc $depha $fehler_depha $nue_dip]
		} else {
			tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		}
		return $Ergebnis
		} elseif {$kappa == ""} {
			tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
			return 0
		}
	}
}

#procedure for reverse calculation
proc reversberechnen {Funktionsname kappa tau tau_exc depha fehler_depha nue_dip} {
	global textpart
	if {$Funktionsname == "funktionpostc7" && $kappa != ""} {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $tau_exc] && [regexp {^[0-9]*\.?[0-9]+$} $tau] && [regexp {^[0-9]*\.?[0-9]+$} $kappa]} {
			set Funktionges "$Funktionsname $kappa $tau $tau_exc"
			set  Ergebnis [$Funktionsname "$kappa $tau $tau_exc $nue_dip"]
			set first_min [funktionpostc7 "$kappa $tau $tau_exc [nue_dip_max [lreplace $Funktionges 0 0 funktionpostc7_ref]]"]
			if {$first_min  > $Ergebnis} {
				set nue_dip_max [nue_dip_max $Funktionges]
				set intervall [expr (abs($nue_dip_max) + 200) / 100]
				set steps [expr (abs($nue_dip_max) + 200) / $intervall]
				set value [plotfunction  funktionpostc7 "$kappa $tau $tau_exc" 1 $steps $intervall]
				set value1 [plotfunction  funktionpostc7_expansion "$kappa $tau 0" 1 $steps $intervall]
				set abs_nu_dip_max [expr abs($nue_dip_max)]
				toplevel .warnung
				wm title .warnung "$textpart(20)"
				blt::graph .warnung.graph1
				bind .warnung.graph1 <ButtonPress-1> { RegionStart %W %x %y }
				bind .warnung.graph1 <B1-Motion> { RegionMotion %W %x %y }
				bind .warnung.graph1 <ButtonRelease-1> { RegionEnd %W %x %y }
				bind .warnung.graph1 <ButtonRelease-3> { Unzoom %W }
				bind .warnung.graph1 <Double-ButtonPress-1> {punkt %W %x %y}
				.warnung.graph1 axis configure x -title "$textpart(42)"
				.warnung.graph1 axis configure y -title "$textpart(43)"
				.warnung.graph1 element create line0 -symbol "" -label $textpart(117) -xdata [lindex $value 0] -ydata [lindex $value 1]
				.warnung.graph1 element create line1 -symbol "" -label $textpart(118) -color red -xdata [lindex $value1 0] -ydata [lindex $value1 1]
				.warnung.graph1 element create line2 -symbol cross -fill blue -label "" -xdata [expr abs($nue_dip)] -ydata $Ergebnis 
				.warnung.graph1 marker create line -coords { 100000 $Ergebnis 0 $Ergebnis}
				tk_messageBox -message "$textpart(116)" -title "$textpart(20)" -type ok
				pack .warnung.graph1
			}
			return "$nue_dip {} {} $Ergebnis"
		#} else {
			#tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
			#return 0
		#}
	#for the inadequate pulse sequence
	} elseif  {$Funktionsname == "funktioninadequate" && $kappa != "" } {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $tau]} {
			set  Ergebnis [$Funktionsname "$kappa $tau $nue_dip"]
			return "$nue_dip {} {} $Ergebnis"
		#} else {
			tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
			return 0
		#}
	#} elseif { $kappa == ""} {
	#	tk_messageBox -message "No Puls-Sequence selectet!" -title "$textpart(20)" -type ok
	#	return 0

	} else {
		tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
		return 0
	}
	#set Fehler ""
	#set nue_dip_max ""

}
#Searching for the Minimum Value in a given Plot
proc min {yliste xliste} {
	set i [llength $yliste]
	set min [lindex $yliste 0]
	for {set j 0} {$j <= [expr $i - 1]} {incr j} {
		if {[lindex $yliste $j] <= [lindex $min 0]} {
			set min "[lindex $yliste $j] [lindex $xliste $j]"
		}
	}
	return $min
}

#procedure to calculate the upper interval border
#requires Funktionsvariablen (Funktionsname kappa tau (tau_exc))
proc nue_dip_max {Funktionsvariablen} {
	global textpart
	if {[lindex $Funktionsvariablen 0] == "funktionpostc7"} {
		#search the absolut maximum
		set Funktionsvariablen_expansion "funktionpostc7_expansion [lindex $Funktionsvariablen 1] [lindex $Funktionsvariablen 2] 0"
		set nue_dip_max_expansion [nue_dip_max $Funktionsvariablen_expansion]
		set x -1
		set x_values {}
		set y_values {}
		while {$x >= [expr $nue_dip_max_expansion - 500]} {
			lappend x_values $x
			lappend y_values  [expr [funktionpostc7 "[lrange $Funktionsvariablen 1 end] $x"]]
			incr x -50
		}
		set minimum [lindex [min $y_values $x_values] 1]
		set Intervallvariablen "[expr $minimum - 50] [expr $minimum + 50] 0.0"
		set Funktionsvariablen_exakt [lreplace $Funktionsvariablen 0 0 derv_[lindex $Funktionsvariablen 0]]
		set Ergebnis [intervallhalbierung $Funktionsvariablen_exakt $Intervallvariablen]

	} else {
		#search the intervall start: increment x-value until fucntionvalue raises again
		set Referenz 1
		set x_Wert -10
		if {[[lindex $Funktionsvariablen 0] "[lrange $Funktionsvariablen 1 end] $x_Wert"] == "$textpart(22)"} {return "$textpart(22)"}
		set Wert [[lindex $Funktionsvariablen 0] "[lrange $Funktionsvariablen 1 end] $x_Wert"]
		while {$Referenz >= $Wert} {
			set Referenz $Wert
			incr x_Wert -10
			set Wert [[lindex $Funktionsvariablen 0] "[lrange $Funktionsvariablen 1 end] $x_Wert"]
			#puts "$Referenz $Wert"
		}
		#search the null of the derivation == nue_dip_max
		set Funktionsvariablen2 [lreplace $Funktionsvariablen 0 0 derv_[lindex $Funktionsvariablen 0]]
		set Intervallvariablen "$x_Wert 50.0 0.0"
		set Ergebnis [intervallhalbierung $Funktionsvariablen2 $Intervallvariablen]
	}
return $Ergebnis
}

#procedure for the normal calculation
proc Normalberechnen {Funktionsname kappa tau tau_exc depha fehler_depha} {
	global textpart
	#for the postC7 pulse sequence
	wm title . "$textpart(121)"
	if { [ winfo exists .calc] } {
		destroy .calc
	}
	toplevel .calc 
	wm title .calc "$textpart(121)"
	label .calc.l -text "$textpart(120)"
	pack .calc.l
	focus .calc.l
	wm transient .calc .
	update idletasks
	set Funktionsvariablen "$kappa $tau $tau_exc $depha"
	set Funktionsvar "$Funktionsname $kappa $tau $tau_exc"
	set Funktionges "$Funktionsname $kappa $tau $tau_exc"
	#after 1000
	set nue_dip_max [nue_dip_max $Funktionges]
	if {$nue_dip_max == "$textpart(22)"} {
		wm title . "$textpart(1)"
		destroy .calc
		update idletasks
		return $textpart(22)
	}
	if {[$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]] != "$textpart(22)"} {
		if {[expr [format %.2f [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]]]] >= $depha} {
			wm title . "$textpart(1)"
			destroy .calc
			update idletasks
			tk_messageBox -message "$textpart(64) \[1 - [expr [format %.2f [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]]] + 0.01]\]" -title "$textpart(20)" -type ok
			return "$textpart(22)"	
		}
	} elseif { [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]] == "$textpart(22)"} {
		wm title . "$textpart(1)"
		destroy .calc
		update idletasks
		return "$textpart(22)"
	}
	#calculate x-value of the function
	if {$Funktionsname == "funktionpostc7" && $kappa != ""} {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $tau_exc] && [regexp {^[0-9]*\.?[0-9]+$} $depha] && [regexp {^[0-9]*\.?[0-9]+$} $fehler_depha]\
		#&& [regexp {^[0-9]*\.?[0-9]+$} $tau] && [regexp {^[0-9]*\.?[0-9]+$} $kappa]} {
			set Functionvariables "$kappa $tau $tau_exc"
			#set intervall
			set Intervallges "$nue_dip_max 0.0 $depha"
			set first_min [funktionpostc7 "$kappa $tau $tau_exc [nue_dip_max [lreplace $Funktionges 0 0 funktionpostc7_ref]]"]
			set Ergebnis [intervallhalbierung $Funktionges $Intervallges]
			if {$first_min > $depha } {
				set intervall [expr (abs($nue_dip_max) + 200) / 100]
				set steps [expr (abs($nue_dip_max) + 200) / $intervall]
				set value [plotfunction  funktionpostc7 "$kappa $tau $tau_exc" 1 $steps $intervall]
				set value1 [plotfunction  funktionpostc7_expansion "$kappa $tau 0" 1 $steps $intervall]
				set abs_nu_dip_max [expr abs($nue_dip_max)]
				if { [ winfo exists .warnung] } {
					destroy .warnung
				}
				toplevel .warnung
				wm title .warnung "$textpart(20)"
				blt::graph .warnung.graph1
				bind .warnung.graph1 <ButtonPress-1> { RegionStart %W %x %y }
				bind .warnung.graph1 <B1-Motion> { RegionMotion %W %x %y }
				bind .warnung.graph1 <ButtonRelease-1> { RegionEnd %W %x %y }
				bind .warnung.graph1 <ButtonRelease-3> { Unzoom %W }
				bind .warnung.graph1 <Double-ButtonPress-1> {punkt %W %x %y}
				.warnung.graph1 axis configure x -title "$textpart(42)"
				.warnung.graph1 axis configure y -title "$textpart(43)"
				.warnung.graph1 element create line0 -symbol "" -label $textpart(117) -xdata [lindex $value 0] -ydata [lindex $value 1]
				.warnung.graph1 element create line1 -symbol "" -label $textpart(118) -color red -xdata [lindex $value1 0] -ydata [lindex $value1 1]
				.warnung.graph1 element create line2 -symbol cross -fill blue -label "" -xdata [expr abs($Ergebnis)] -ydata $depha 
				.warnung.graph1 marker create line -coords { 100000 $depha 0 $depha}
				pack forget .calc
				pack .warnung.graph1
				tk_messageBox -message "$textpart(116)" -title "$textpart(20)" -type ok
				update idletasks
				
			}
			#calculate result
			if {$Ergebnis == "$textpart(22)"} {
				wm title . "$textpart(1)"
				destroy .calc
				update idletasks
				return "$textpart(22)"
			}
			set Fehler [Fehler $Funktionges $fehler_depha $Ergebnis]
			wm title . "$textpart(1)"
			destroy .calc
			update idletasks
			return "$Ergebnis $Fehler $nue_dip_max $depha"
		#} else {
		#	tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		#	return 0
		#}
	#for the inadequate pulse sequence
	} elseif  {$Funktionsname == "funktioninadequate" && $kappa != ""} {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $depha] && [regexp {^[0-9]*\.?[0-9]+$} $fehler_depha]\
		#&& [regexp {^[0-9]*\.?[0-9]+$} $tau]} {
			set Funktionges "$Funktionsname $kappa $tau"
			set Functionvariables "$kappa $tau"
			#set intervall
			#set nue_dip_max [nue_dip_max $Funktionges]
			set Intervallges "$nue_dip_max 0.0 $depha"
			#calculate result
			set Ergebnis [intervallhalbierung $Funktionges $Intervallges]
			if {$Ergebnis == "$textpart(22)"} {
				wm title . "$textpart(1)"
				destroy .calc
				update idletasks
				return "$textpart(22)"
			}
			set Fehler [Fehler $Funktionges $fehler_depha $Ergebnis]
			wm title . "$textpart(1)"
			destroy .calc
			update idletasks
			return "$Ergebnis $Fehler $nue_dip_max $depha"
		#} else {
		#	tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
		#	return 0
		#}
	} else {
		wm title . "$textpart(1)"
		destroy .calc
		update idletasks
		tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
		return 0
	}
	wm title . "$textpart(1)"
	destroy .calc
	update idletasks
}


#procedure for the normal calculation from an inputfile
proc Berechneninput {Funktionsname kappa tau tau_exc depha fehler_depha output} {
	global textpart
	#for the postC7 pulse sequence
	set Funktionsvariablen "$kappa $tau $tau_exc $depha"
	set Funktionsvar "$Funktionsname $kappa $tau $tau_exc"
	set Funktionges "$Funktionsname $kappa $tau $tau_exc"
	set nue_dip_max [nue_dip_max $Funktionges]
	if {$nue_dip_max == "$textpart(22)"} {
		return $textpart(22)
	}
	if {[$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]] != "$textpart(22)"} {
		if {[expr [format %.2f [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]]]] >= $depha} {
			tk_messageBox -message "$textpart(64) \[1 - [expr [format %.2f [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]]] + 0.01]\]" -title "$textpart(20)" -type ok
			return "$textpart(22)"	
		}
	} elseif { [$Funktionsname [lreplace $Funktionsvariablen end end $nue_dip_max]] == "$textpart(22)"} {
		return "$textpart(22)"
	}
	#calculate x-value of the function
	if {$Funktionsname == "funktionpostc7" && $kappa != ""} {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $tau_exc] && [regexp {^[0-9]*\.?[0-9]+$} $depha] && [regexp {^[0-9]*\.?[0-9]+$} $fehler_depha]\
		#&& [regexp {^[0-9]*\.?[0-9]+$} $tau] && [regexp {^[0-9]*\.?[0-9]+$} $kappa]} {
			set Functionvariables "$kappa $tau $tau_exc"
			#set intervall
			set Intervallges "$nue_dip_max 0.0 $depha"
			set first_min [funktionpostc7 "$kappa $tau $tau_exc [nue_dip_max [lreplace $Funktionges 0 0 funktionpostc7_ref]]"]
			set Ergebnis [intervallhalbierung $Funktionges $Intervallges]
			if {$first_min > $depha } {
				puts $output "#$textpart(119)"
			}
			#calculate result
			if {$Ergebnis == "$textpart(22)"} {return "$textpart(22)"}
			set Fehler [Fehler $Funktionges $fehler_depha $Ergebnis]
			return "$Ergebnis $Fehler $nue_dip_max $depha"
		#} else {
		#	tk_messageBox -message "$textpart(63)" -title "$textpart(20)" -type ok
		#	return 0
		#}
	#for the inadequate pulse sequence
	} elseif  {$Funktionsname == "funktioninadequate" && $kappa != ""} {
		#if {[regexp {^[0-9]*\.?[0-9]+$} $depha] && [regexp {^[0-9]*\.?[0-9]+$} $fehler_depha]\
		#&& [regexp {^[0-9]*\.?[0-9]+$} $tau]} {
			set Funktionges "$Funktionsname $kappa $tau"
			set Functionvariables "$kappa $tau"
			#set intervall
			#set nue_dip_max [nue_dip_max $Funktionges]
			set Intervallges "$nue_dip_max 0.0 $depha"
			#calculate result
			set Ergebnis [intervallhalbierung $Funktionges $Intervallges]
			if {$Ergebnis == "$textpart(22)"} {return "$textpart(22)"}
			set Fehler [Fehler $Funktionges $fehler_depha $Ergebnis]
			return "$Ergebnis $Fehler $nue_dip_max $depha"
		#} else {
		#	tk_messageBox -message "$textpart(62)" -title "$textpart(20)" -type ok
		#	return 0
		#}
	} else {
		tk_messageBox -message "$textpart(66)" -title "$textpart(20)" -type ok
		return 0
	}

}

# function to plot a outputfile (nue_dip vs. dephasingtime) and to export the plot as EPS
proc plotoutput {outfiledir installdir Browser platform} {
	global textpart
	set shift 1
	set rows 0
	if {[file exists $outfiledir] == 1 &&  [file extension $outfiledir] == ".out"} {
		set plotdata [open $outfiledir r]
		while {[gets $plotdata Zeile] >= 0} {
			if {[regexp ^\# $Zeile] || $Zeile == ""} {
				continue
			}
			set j 0
			for {set i 0} {$i <= [expr [llength $Zeile]-1]} {incr i 1} {
				if {[llength $Zeile] == 6 && $i == 1} {
				set data($rows,$j) ""
				incr j 1
				}
				set data($rows,$j) [lindex $Zeile $i]
				incr j 1
			}
			incr rows 1
		}
		close $plotdata
	} else {
		tk_messageBox -message "$textpart(67)" -title "$textpart(20)" -type ok
		return 0
	}
	#create and split toplevel
	if { [ winfo exists .plotout] } {
		destroy .plotout
	}
	toplevel .plotout
	wm title .plotout "$textpart(68)"
	frame .plotout.plot
	frame .plotout.button
	pack .plotout.plot .plotout.button -side top
	#creating plot
	blt::graph .plotout.plot.graph
	bind .plotout.plot.graph <ButtonPress-1> { RegionStart %W %x %y }
	bind .plotout.plot.graph <B1-Motion> { RegionMotion %W %x %y }
	bind .plotout.plot.graph <ButtonRelease-1> { RegionEnd %W %x %y }
	bind .plotout.plot.graph <ButtonRelease-3> { Unzoom %W }
	bind .plotout.plot.graph <Double-ButtonPress-1> {punkt %W %x %y}
	#plot every row in outputfile
	for {set i 0} {$i <= [expr $rows - 1]} {incr i 1} {
	.plotout.plot.graph element create line$i -symbol cross -label "" -errorbarwidth 2 -xdata [expr $data($i,0) * 1000] -ydata $data($i,4)\
	-yhigh [expr $data($i,4) + $data($i,5)] -ylow [expr $data($i,4) - $data($i,5)]
	}
	.plotout.plot.graph axis configure x -title "$textpart(69)"
	.plotout.plot.graph axis configure y -title "$textpart(70)"
	pack .plotout.plot.graph
	button .plotout.button.help -text "$textpart(24)" -command {
		invokebrowser $installdir/dipolcalculator_help/index.html $platform
	}
	button .plotout.button.export -text "$textpart(46)" -command {
		toplevel .printplot
		wm title .printplot "$textpart(71)"
		#split toplevel

		#label and entry field
		frame .printplot.oben -bd 2

		#button field
		frame .printplot.unten -bd 2
		pack .printplot.oben .printplot.unten -side top

		#create label and entry field
		label .printplot.oben.l_filepath -text "$textpart(47)"
		entry .printplot.oben.e_filepath -width 20 -textvariable plotdir
		pack .printplot.oben.l_filepath .printplot.oben.e_filepath -side left
		bind .printplot.oben.e_filepath <KeyPress-Return> {.printplot.unten.b_ok invoke}
		focus .printplot.oben.e_filepath
		#create button field
		button .printplot.unten.b_ok -text "$textpart(31)" -command {
				#export to EPS
				.plotout.plot.graph postscript output $plotdir
				destroy .printplot
				tk_messageBox -message "$textpart(48) $plotdir " -title "$textpart(20)" -type ok
				}
				pack .printplot.unten.b_ok

		}
		pack .plotout.button.export .plotout.button.help -side right
}

#proc to load the Tree
proc LoadTree {tree parentNode dir} {
	foreach e [$tree children $parentNode] {
		$tree delete $e
	}
	global textpart
	set saved [pwd]
	cd $dir
	foreach f [lsort [glob -nocomplain *]] {
		if {[regexp {^~} $f] } {
			continue
		}
		set node [$tree insert $parentNode -label $f]
		if { [file isdirectory $f] } {
			#LoadTree $tree $node $f
			set saved1 [pwd]
			cd $f
			foreach g [lsort [glob -nocomplain *]] {
				if {[regexp {^~} $g] } {
					continue
				}
				foreach e [$tree children $node] {
					$tree delete $e	
				}
				set node [$tree insert $node -label $g]
			}
			cd $saved1
		} 
	}
	cd $saved
}

#proc to browse for files
proc browse {homedir tree} {
	global textpart
	global filename
	set file Hallo
	if { [ winfo exists .browser] } {
		destroy .browser
	}
	toplevel .browser
	wm title .browser "$textpart(72)"
	frame .browser.oben
	LoadTree $tree 0 $homedir
	blt::treeview .browser.oben.t -tree $tree -yscrollcommand ".browser.oben.scrolly set" -xscrollcommand ".browser.scrollx set"
	scrollbar .browser.oben.scrolly -command ".browser.oben.t yview" 
	scrollbar .browser.scrollx -command ".browser.oben.t xview" -orient horizontal 
	pack .browser.oben .browser.scrollx -side top -fill x
	pack .browser.oben.t .browser.oben.scrolly -side left -fill y
	.browser.oben.t bind all <Double-ButtonPress-1> {
		set path [::tree0 path [.browser.oben.t curselection]]
		set totalpath $homedir
		foreach Element $path {
			set totalpath "$totalpath/$Element"
		}
		if {[file isdirectory $totalpath]==1} {
			LoadTree ::tree0 [.browser.oben.t curselection] $totalpath
		} elseif {[file isdirectory $totalpath]==0} {
			set filename $totalpath
		destroy	.browser
		}
	}

}

proc browserlinux { } {
       
       foreach browser {firefox htmlview mozilla konqueror netscape} {
            set binary [lindex [auto_execok $browser] 0]
            if {[string length $binary]} {
    		return $binary
                break
            }
       }
}

proc invokebrowser {file platform} {
	global textpart
	global env
	if {[regexp {^Linux*} $platform]} {
		exec [browserlinux] $file &
	} elseif {[regexp {^Windows NT*} $platform]} {
		exec $env(COMSPEC) /c start $file &
	} elseif {[regexp {^Windows 95\/98*} $platform]} {
		exec start $file &
	}
}
proc umrechen {graph x y} {
	set xmax [lindex [$graph  axis limits x] 1]
	set xmin [lindex [$graph  axis limits x] 0]
	set ymax [lindex [$graph  axis limits y] 1]
	set ymin [lindex [$graph  axis limits y] 0]
	set yoffset [lindex [$graph transform $xmax $ymax] 1]
	set xoffset [lindex [$graph transform $xmin $ymin] 0]
	set pixelx [expr [lindex [$graph transform $xmax $ymax] 0 ]-[lindex [$graph transform $xmin $ymin] 0]]
	set pixely [expr [lindex [$graph transform $xmin $ymin] 1] - [lindex [$graph transform $xmax $ymax] 1]]
	set dx [expr [lindex [$graph  axis limits x] 1] - [lindex [$graph  axis limits x] 0]]
	set dy [expr [lindex [$graph  axis limits y] 1] - [lindex [$graph  axis limits y] 0]]
	return "[expr $xmin + ($dx/$pixelx *($x-$xoffset))] [expr $ymax - ($dy/$pixely*($y-$yoffset))]"
}

proc Zoom { graph x1 y1 x2 y2 } {
	if { $x1 > $x2 } {
		$graph axis configure x -min $x2 -max $x1
	} elseif { $x1 < $x2 } {
		$graph axis configure x -min $x1 -max $x2
	}
	if { $y1 > $y2 } {
		$graph axis configure y -min $y2 -max $y1
	} elseif { $y1 < $y2 } {
		$graph axis configure y -min $y1 -max $y2
	}
}

proc Unzoom { graph } {
	$graph axis configure x y -min {} -max {}
}

proc RegionStart { graph x y } {
	global x0 y0
	$graph marker create line -coords {  } -name myLine -dashes dash -xor yes
	set x0 [lindex [umrechen $graph $x $y] 0]; set y0 [lindex [umrechen $graph $x $y] 1]

}
proc RegionMotion { graph x y } {
	global x0 y0
	set coord [umrechen $graph $x $y]
	set x [lindex $coord 0]
	set y [lindex $coord 1]
	#$graph marker coords myLine "$x0 $y0 $x0 $y $x $y $x $y0 $x0 $y0"
	$graph marker create line -coords { $x0 $y0 $x0 $y $x $y $x $y0 $x0 $y0 } -name myLine -dashes dash -xor yes
}

proc RegionEnd { graph x y } {
	global x0 y0
	$graph marker delete myLine
	set coord [umrechen $graph $x $y]
	set x [lindex $coord 0]
	set y [lindex $coord 1]
	Zoom $graph $x0 $y0 $x $y
}

proc punkt { graph x y } {
	set coord [umrechen $graph $x $y]
	set x [format %.2f [lindex $coord 0] ]
	set y [format %.2f [lindex $coord 1] ]
	set xmax [lindex [$graph  axis limits x] 1]
	set xmin [lindex [$graph  axis limits x] 0]
	set ymax [lindex [$graph  axis limits y] 1]
	set ymin [lindex [$graph  axis limits y] 0]
	set yoffset [lindex [$graph transform $xmax $ymax] 1]
	set xoffset [lindex [$graph transform $xmin $ymin] 0]
	set pixelx [expr [lindex [$graph transform $xmax $ymax] 0 ]-[lindex [$graph transform $xmin $ymin] 0]]
	set pixely [expr [lindex [$graph transform $xmin $ymin] 1] - [lindex [$graph transform $xmax $ymax] 1]]
	set dx [expr [lindex [$graph  axis limits x] 1] - [lindex [$graph  axis limits x] 0]]
	set dy [expr [lindex [$graph  axis limits y] 1] - [lindex [$graph  axis limits y] 0]]
	#return "[expr $xmin + ($dx/$pixelx *($x-$xoffset))] [expr $ymax - ($dy/$pixely*($y-$yoffset))]"
	set xcoord [expr $x + $dx/$pixelx * 40]
	set ycoord [expr $y + $dy/$pixely* 40]
	$graph marker create text -text "($x,$y)" -coords { $xcoord $ycoord}
	$graph element create line$x -symbol cross -ydata $y -xdata $x -label ""
}

########################################################################################################################
#Creatig arrays for the pulse sequence symmetry menu
########################################################################################################################
#C-Sequences
set Zeilenzahl 1
if {[file exists "$installdir/DQ-C-N20-n10.txt"] == 1} {
	set Datei [open "$installdir/DQ-C-N20-n10.txt" r]
	while {[gets $Datei Zeile] >= 0} {
		if {[regexp ^\# $Zeile] || $Zeile == "" } {
		continue
		}
		if {$Zeilenzahl == 1} {
			set Chead $Zeile
			incr Zeilenzahl 1
			continue
		}
		if {$Zeilenzahl == 2} {
			set ref [lindex $Zeile 1]
			set j 0
			set z1 1
		}
		if {$ref == [lindex $Zeile 1]} {
			set clength [llength $Zeile]
			for {set i 0} {$i <= [expr [llength $Zeile]-1]} {incr i 1} {
				set CSequenz($z1,$j) [lindex $Zeile $i]
				incr  j 1
			}
		} else {
			set ref [lindex $Zeile 1]
			incr z1 1
			set j 0
			for {set i 0} {$i <= [expr [llength $Zeile]-1]} {incr i 1} {

				set CSequenz($z1,$j) [lindex $Zeile $i]
				incr  j 1
			}
		}
	incr Zeilenzahl 1
	}
}
close $Datei
#R-Sequences
set Zeilenzahl2 1
if {[file exists "$installdir/DQ-R-N80-n10.txt"] == 1} {
	set Datei [open "$installdir/DQ-R-N80-n10.txt" r]
	while {[gets $Datei Zeile] >= 0} {
		if {[regexp ^\# $Zeile] || $Zeile == "" } {
		continue
		}
		if {$Zeilenzahl2 == 1} {
			set Rhead $Zeile
			incr Zeilenzahl2 1
			continue
		}
		if {$Zeilenzahl2 == 2} {
			set ref [lindex $Zeile 1]
			set j 0
			set z2 1
		}
		if {$ref == [lindex $Zeile 1]} {
			set rlength [llength $Zeile]
			for {set i 0} {$i <= [expr [llength $Zeile]-1]} {incr i 1} {
				set RSequenz($z2,$j) [lindex $Zeile $i]
				incr  j 1
			}
		} else {
			set ref [lindex $Zeile 1]
			incr z2 1
			set j 0
			for {set i 0} {$i <= [expr [llength $Zeile]-1]} {incr i 1} {
				set RSequenz($z2,$j) [lindex $Zeile $i]
				incr  j 1
			}
		}
	incr Zeilenzahl2 1
	}
}
close $Datei



########################################################################################################################
#procs for the favorits menu
########################################################################################################################
proc updatefavmen {installdir} {
	global textpart
	set Zeilefav 0
	set favorits ""
	destroy .main.oben2.buttonframe.right.menups.menue.fav
	menu .main.oben2.buttonframe.right.menups.menue.fav -tearoff 0
	if {[file exists "$installdir/favorits.txt"] == 1} {
		set Datei [open "$installdir/favorits.txt" r]
		while {[gets $Datei Zeile] >= 0} {
			if {[regexp ^\# $Zeile] || $Zeile == "" } {
				continue
			}
			set favorits [lappend favorits $Zeile]
			incr Zeilefav 1

		}
		close $Datei
	} else {
		set favorits [lappend favorits "{$textpart(73)}"]
	}

	if {$Zeilefav == 0} {
		set favorits [lappend favorits "{$textpart(73)}"]
	}
	return $favorits
}

proc updatefavfile {favorits seq sym kappa shortcut installdir} {
	global textpart
	set Datei [open "$installdir/favorits.txt" w]
	puts $Datei "$seq {$sym} $kappa $shortcut"
	for {set i 0} {$i <= [llength $favorits]} {incr i 1} {
		if {$i == "9"} {break}
		if {[lindex $favorits $i] != "{$textpart(73)}"} {
			puts $Datei [lindex $favorits $i]
		}
	}
	close $Datei

}
