#! /usr/bin/wish
#read config file
wm title . "Powerlevel calculator 0.5"
set platform $tcl_platform(os)
if {[regexp {^Linux*} $platform]} {
	if {[file exists "$env(HOME)/.powlevelcalc"] == 1} {
		set configf "$env(HOME)/.powlevelcalc"
		source "$env(HOME)/.powlevelcalc"
	} else {
		#tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		#exit
		source "./config.tcl"
		set configf "$env(HOME)/.powlevelcalc"
		source "$env(HOME)/.powlevelcalc"	
	}
} elseif {[regexp {^Windows NT*} $platform]} {
	if {[file exists "$env(HOME)/powlevelcalc.init"] == 1} {
		set configf "$env(HOME)/powlevelcalc.init"
		source "$env(HOME)/powlevelcalc.init"
	} else {
		#tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		#exit
		source "./config.tcl"
		set configf "$env(HOME)/.powlevelcalc"
		source "$env(HOME)/.powlevelcalc"
	}
} elseif {[regexp {^Windows 95\/98*} $platform]} {
	if {[file exists "$env(HOME)/powlevelcalc.init"] == 1} {
		set configf "$env(HOME)/powlevelcalc.init"
		source"$env(HOME)/powlevelcalc.init"
	} else {
		#tk_messageBox -message "No configuration file found! Run config.tcl!" -title "$textpart(20)" -type ok
		#exit
		source "./config.tcl"
		set configf "$env(HOME)/.powlevelcalc"
		source "$env(HOME)/.powlevelcalc"
	}
}
proc browserlinux { } {
        foreach browser {firefox htmlview mozilla konqueror netscape} {
            set binary [lindex [auto_execok $browser] 0]
            if {[string length $binary]} {
                return $binary
                break
            }
        }
}
if {[regexp {^Linux*} $platform]} {
        set Browser "[browserlinux]"
} elseif {[regexp {^Windows NT*} $platform]} {
        set Browser "\$env(COMSPEC) /c start"
} elseif {[regexp {^Windows 95\/98*} $platform]} {
        set Browser "start"
}
proc invokebrowser {file platform} {
        global env
        if {[regexp {^Linux*} $platform]} {
                exec [browserlinux] $file &
        } elseif {[regexp {^Windows NT*} $platform]} {
                exec $env(COMSPEC) /c start $file &
        } elseif {[regexp {^Windows 95\/98*} $platform]} {
                exec start $file &
        }
}
#read data file
set Zeilenzahl 0
set Zeilenzahl1 0
if {[file exists $installdir/Daten.dat] == 1} {
	set Datei [open $installdir/Daten.dat r]
	while {[gets $Datei Zeile] >= 0} {
		set txt($Zeilenzahl1) $Zeile
		incr Zeilenzahl1
		if {[regexp ^\# $Zeile] || $Zeile == "" } {
			continue
		}
		set headl [llength $Zeile]
		if {$Zeilenzahl == 0} {
			set head [lindex $Zeile 0]
			for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
				set Probenkopf($i) [lindex $Zeile $i]
			}
			incr Zeilenzahl 1
			continue
		}
		if {$Zeilenzahl == 1} {
			for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
				set maxnutfrqu($i) [lindex $Zeile $i]
			}
			incr Zeilenzahl 1
			continue
		}
		set nucall($Zeilenzahl) [lindex $Zeile 0]
		for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
			set daten($i) [lappend daten($i) [lindex $Zeile $i]]
		}
		set head [lappend head [lindex $Zeile 0]]
		incr Zeilenzahl 1
	}
} else {
	tk_messageBox -message "Data file does not exist!" -title "Warning" -type ok
	exit
}
close $Datei
#settin variables
set winkel 10
#main window
frame .menu -relief raised -bd 2
frame .oben
frame .fenster
pack .menu .oben .fenster -fill x -side top
frame .oben.menus
frame .oben.werte
pack .oben.menus .oben.werte -side left
menubutton .oben.menus.probenkopf -text "probe" -menu .oben.menus.probenkopf.menue -relief raised -width 40
menubutton .oben.menus.kern -text "Nucleus" -menu .oben.menus.kern.menue -relief raised  -width 40
menu .oben.menus.kern.menue -tearoff 0
menu .oben.menus.probenkopf.menue -tearoff 0
for {set i 1} {$i <= [expr $headl-1]} {incr i 1} {
	.oben.menus.probenkopf.menue add cascade -label "$Probenkopf($i)" -menu .oben.menus.probenkopf.menue.$i
	menu .oben.menus.probenkopf.menue.$i -tearoff 0
	.oben.menus.probenkopf.menue.$i add command -label "Select" -command {
		if {[.oben.menus.probenkopf.menue index active] == "none"} {	
		} else {
		set kopfindex [expr [.oben.menus.probenkopf.menue index active] +1]
		.oben.menus.probenkopf configure -text "$Probenkopf($kopfindex)"
		.oben.menus.kern configure -text "Nucleus"
		destroy .oben.menus.kern.menue
		menu .oben.menus.kern.menue -tearoff 0
		for {set j 1} {$j <= [expr [llength $daten($kopfindex)] -1]} {incr j 2} {
			if {[lindex $daten($kopfindex) $j] != "x"} {
				.oben.menus.kern.menue add cascade -label "[lindex [lindex $head [expr $j + 1]] 0 ]" -menu .oben.menus.kern.menue.$j
				menu .oben.menus.kern.menue.$j -tearoff 0
				.oben.menus.kern.menue.$j add command -label "Select" -command {
				if {[.oben.menus.kern.menue index active] == "none"} {
				} else {
					set kernindex [expr [.oben.menus.kern.menue index active]]
					set g 0
					set add 0
					set ref 0
					while { $ref <= $kernindex} {
						if {[lindex $daten($kopfindex) [expr $g*2]] != "x"} {
							incr ref 1
							incr g 1
						} elseif {[lindex $daten($kopfindex) [expr $g*2]] == "x"} {
							incr add 1
							incr g 1
						}
					}
					set kernindex [expr $kernindex + $add]
					.oben.menus.kern configure -text "[lindex [lindex $head [expr $kernindex*2+2]] 0 ]"
					set pl [lindex $daten($kopfindex) [expr $kernindex *2]]
					set nutfreq  [lindex $daten($kopfindex) [expr $kernindex *2+1] ]
					set probe $Probenkopf($kopfindex)
					set nuc [lindex [lindex $head [expr $kernindex*2+2]] 0 ]
					if {[file exists $configf] == 1} {
						set Dateiw [open "$configf" w]
						puts $Dateiw "set installdir \"$installdir\""
						puts $Dateiw "set probe \"$probe\""
						puts $Dateiw "set nuc \"$nuc\""
						puts $Dateiw "set pl $pl"
						puts $Dateiw "set nutfreq $nutfreq"
						puts $Dateiw "set kopfindex \"$kopfindex\""
						puts $Dateiw "set kernindex \"$kernindex\""
						close $Dateiw
					} else {
						set Dateiw [open "$configf" w]
						puts $Dateiw "set installdir \"$installdir\""
						puts $Dateiw "set Browser \"$Browser\""
						puts $Dateiw "set probe \"$probe\""
						puts $Dateiw "set nuc \"$nuc\""
						puts $Dateiw "set pl $pl"
						puts $Dateiw "set nutfreq $nutfreq"
						puts $Dateiw "set kopfindex \"$kopfindex\""
						puts $Dateiw "set kernindex \"$kernindex\""
						close $Dateiw
					}
				}	
				}
			}
		}
	}
	}
}
pack .oben.menus.probenkopf .oben.menus.kern  -side top
frame .oben.werte.oben
frame .oben.werte.unten
pack .oben.werte.oben .oben.werte.unten -side top
label .oben.werte.oben.l -text "Powerlevel \[dB\]" -width 22
entry .oben.werte.oben.e -width 15 -textvariable pl_e
pack .oben.werte.oben.l .oben.werte.oben.e -side left
label .oben.werte.unten.l -text "Nutation frequency \[kHz\]" -width 22
entry .oben.werte.unten.e -width 15 -textvariable nutfreq_e
pack .oben.werte.unten.l .oben.werte.unten.e -side left
frame .fenster.winkel
frame .fenster.dauer
pack .fenster.winkel .fenster.dauer -side top -fill x
label .fenster.winkel.l -width 15 -text "Pulse angle \[°\]:" -justify right
label .fenster.winkel.90 -width 10 -text "90°"
label .fenster.winkel.180 -width 10 -text "180°"
label .fenster.winkel.270 -width 10 -text "270°"
label .fenster.winkel.360 -width 10 -text "360°"
entry .fenster.winkel.var -width 10 -textvariable winkel -justify right
label .fenster.winkel.grad -text "°"
pack .fenster.winkel.l .fenster.winkel.90 .fenster.winkel.180 .fenster.winkel.270 .fenster.winkel.360 .fenster.winkel.var .fenster.winkel.grad -side left
label .fenster.dauer.l -width 15 -text "Pulse duration \[s\]:" -justify right
entry .fenster.dauer.90 -width 10 -textvariable 90dauer -relief sunken
entry .fenster.dauer.180 -width 10 -textvariable 180dauer -relief sunken
entry .fenster.dauer.270 -width 10 -textvariable 270dauer -relief sunken
entry .fenster.dauer.360 -width 10 -textvariable 360dauer -relief sunken
entry .fenster.dauer.var -width 10 -textvariable vardauer -relief sunken
pack .fenster.dauer.l .fenster.dauer.90 .fenster.dauer.180 .fenster.dauer.270 .fenster.dauer.360 .fenster.dauer.var -side left
bind .fenster.winkel.var <KeyPress-Return> {
	set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360/ [format %%.4f $winkel])]]
}

#settling last configurations

if {$nuc != "0" && $probe != "0"} {
	.oben.menus.kern configure -text "$nuc"
	.oben.menus.probenkopf configure -text "$probe"
} 
# bindings

bind .oben.werte.oben.e <KeyPress-Return> {
	if {[regexp {^-?[0-9]*\.?[0-9]+$} $pl_e] && [regexp {^-?[0-9]*\.?[0-9]+$} $pl] && [regexp {^[0-9]*\.?[0-9]+$} $nutfreq]} {
		if {$pl_e >= -6 && $pl_e <= 120} {
			set nutfreq_e  [expr sqrt(pow(10,( $pl - $pl_e ) / 10.0))*$nutfreq ]
			if {$nutfreq_e >= $maxnutfrqu($kopfindex)} {
				tk_messageBox -message "Warning! Nutation frequency is too high!" -title "Warning" -type ok
			}
			set nutfreq_e [format %%.4f $nutfreq_e]
			set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
			set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
			set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
			set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
			set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
		} else { tk_messageBox -message "Powerlevel out of range!" -title "Warning" -type ok}
	}  else {tk_messageBox -message "Only numbers acepted \[0-9\].\[0-9\]" -title "Warning" -type ok}
}
bind .oben.werte.unten.e <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+$} $nutfreq_e] && [regexp {^[0-9]*\.?[0-9]+$} $pl] && [regexp {^[0-9]*\.?[0-9]+$} $nutfreq]} {
		if {$nutfreq_e >= $maxnutfrqu($kopfindex)} {
			tk_messageBox -message "Warning! Frequency is too high!" -title "Warning" -type ok
		}
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
		set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
		set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
		set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
		set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
	} else {tk_messageBox -message "Only numbers accepted \[0-9\].\[0-9\]" -title "Warning" -type ok}
}
bind .fenster.dauer.90 <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sume]?} $90dauer]} {
		if {[regexp {[s]$} $90dauer]} {
			set 90dauer [format %%f [string trimright $90dauer {s}]]
		} elseif {[regexp {[m]$} $90dauer]} {
			set 90dauer [format %%f [expr [format %%.1f [string trimright $90dauer {m}]]/1000]]
		} elseif {[regexp {[u]$} $90dauer]} {
			set 90dauer [format %%f [expr [format %%.1f [string trimright $90dauer {u}]]/1000000]]
		}
		set nutfreq_e [format %%.4f [expr 1.0/(4000*$90dauer)]]
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
		set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
		set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
		set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
	} 
}
bind .fenster.dauer.180 <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sume]?} $180dauer]} {
		if {[regexp {[s]$} $180dauer]} {
			set 180dauer [format %%f [string trimright $180dauer {s}]]
		} elseif {[regexp {[m]$} $180dauer]} {
			set 180dauer [format %%f [expr [format %%.1f [string trimright $180dauer {m}]]/1000]]
		} elseif {[regexp {[u]$} $180dauer]} {
			set 180dauer [format %%f [expr [format %%.1f [string trimright $180dauer {u}]]/1000000]]
		}
		set nutfreq_e [format %%.4f [expr 2.0/(4000*$180dauer)]]
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
		set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
		set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
		set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
	} 
}
bind .fenster.dauer.270 <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sume]?} $270dauer]} {
		if {[regexp {[s]$} $270dauer]} {
			set 270dauer [format %%f [string trimright $270dauer {s}]]
		} elseif {[regexp {[m]$} $270dauer]} {
			set 270dauer [format %%f [expr [format %%.1f [string trimright $270dauer {m}]]/1000]]
		} elseif {[regexp {[u]$} $270dauer]} {
			set 270dauer [format %%f [expr [format %%.1f [string trimright $270dauer {u}]]/1000000]]
		}
		set nutfreq_e [format %%.4f [expr 3.0/(4000*$270dauer)]]
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
		set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
		set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
		set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
	} 
}
bind .fenster.dauer.360 <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sume]?} $360dauer]} {
		if {[regexp {[s]$} $360dauer]} {
			set 360dauer [format %%f [string trimright $360dauer {s}]]
		} elseif {[regexp {[m]$} $360dauer]} {
			set 360dauer [format %%f [expr [format %%.1f [string trimright $360dauer {m}]]/1000]]
		} elseif {[regexp {[u]$} $360dauer]} {
			set 360dauer [format %%f [expr [format %%.1f [string trimright $270dauer {u}]]/1000000]]
		}
		set nutfreq_e [format %%.4f [expr 4.0/(4000*$360dauer)]]
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
		set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
		set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
		set vardauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/(360.0/$winkel)]]
	} 
}
bind .fenster.dauer.var <KeyPress-Return> {
	if {[regexp {^[0-9]*\.?[0-9]+[sume]?} $vardauer] && [regexp {^[0-9]*\.?[0-9]+$} $winkel]} {
		if {[regexp {[s]$} $vardauer]} {
			set vardauer [format %%f [string trimright $vardauer {s}]]
		} elseif {[regexp {[m]$} $vardauer]} {
			set vardauer [format %%f [expr [format %%.1f [string trimright $vardauer {m}]]/1000]]
		} elseif {[regexp {[u]$} $vardauer]} {
			set vardauer [format %%f [expr [format %%.1f [string trimright $vardauer {u}]]/1000000]]
		}
		set nutfreq_e [format %%.4f [expr 360.0/(1000*$vardauer*$winkel)]]
		set pl_e [expr $pl + 10.0 * log10(pow($nutfreq,2)/pow($nutfreq_e,2))]
		set pl_e [format %%.4f $pl_e]
		set 90dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*1.0]]
		set 180dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*2.0]]
		set 270dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*3.0]]
		set 360dauer [format %%.4e [expr (1.0/($nutfreq_e * 1000))/4.0*4.0]]
	} 
}

menubutton .menu.edit -text "edit probe list" -menu .menu.edit.menu -underline 0
menubutton .menu.info -text "About powerlevelcalculator" -underline 0 -menu .menu.info.menu
pack .menu.edit -side left
pack .menu.info -side right
menu .menu.info.menu
.menu.info.menu add command -label "Info" -underline 0 -command {
	toplevel .info
	wm title .info "About powerlevelcalculator"
	label .info.text -text "Powerlevelcalculator version 0.5 \n\u00A9 Contributors: Joern Schmedt auf der Guenne, Philipp von den Hoff. \nfor more information visit: www.cup.uni-muenchen.de/ac/schmedtadg/index.html"
	button .info.b -text "OK" -command {destroy .info}
	pack .info.text .info.b -side top
	bind .info.text <Any-ButtonPress> {
		invokebrowser www.cup.uni-muenchen.de/ac/schmedtadg/index.html $platform
	}
}
menu .menu.edit.menu -tearoff 0
.menu.edit.menu add command -label "Edit current entry" -underline 5 -command {
	set title "Edit current entry"
	if {$kopfindex != 0} {
		set eprobe $Probenkopf($kopfindex)
		set enuc $nuc
		set enutfreq $maxnutfrqu($kopfindex)
		set enucdb [lindex $daten($kopfindex) [expr $kernindex *2]]
		set enuckh [lindex $daten($kopfindex) [expr $kernindex *2+1] ]
		editlist $eprobe $enuc 	$enutfreq $enucdb $enuckh
	}
}

.menu.edit.menu add command -label "Delete current entry" -underline 0 -command {
	set title "Delete current entry"
	if {$kopfindex != 0} {
		set eprobe $Probenkopf($kopfindex)
		set enuc $nuc
		set enutfreq $maxnutfrqu($kopfindex)
		set enucdb "x"
		set enuckh "x"
		editlist $eprobe $enuc 	$enutfreq $enucdb $enuckh
	}
}

.menu.edit.menu add command -label "Add new nucleus" -underline 6 -command {
	set title "Add new nucleus"
	if {$kopfindex != 0} {
		set eprobe $Probenkopf($kopfindex)
		set enuc ""
		set enutfreq $maxnutfrqu($kopfindex)
		set enucdb ""
		set enuckh ""
		editlist $eprobe $enuc 	$enutfreq $enucdb $enuckh
	}
}

.menu.edit.menu add command -label "Add new probe" -underline 5 -command {
	set title "Add new probe"
	if {$kopfindex != 0} {
		set eprobe ""
		set enuc ""
		set enutfreq ""
		set enucdb ""
		set enuckh ""
		editlist $eprobe $enuc 	$enutfreq $enucdb $enuckh
	}
}

proc editlist {eprobe enuc enutfreq enucdb enuckh} {
upvar	Probenkopf Probenkopf nuc nuc maxnutfrqu maxnutfrqu daten daten kernindex kernindex kopfindex kopfindex txt txt installdir installdir title title
if {$kopfindex != 0} {
	toplevel .editcurrent
	wm title .editcurrent $title
	frame .editcurrent.left 
	frame .editcurrent.right 
	pack .editcurrent.left .editcurrent.right -side left  -fill y
	label .editcurrent.left.l_prob -text "probe"
	label .editcurrent.left.l_nuc -text "nucleus"
	label .editcurrent.left.l_nutfreq -text "max. nut. frequency:" -width 24 -anchor nw
	label .editcurrent.left.l_nucdb -text "Powerlevel \[dB\]:" -width 24 -anchor nw
	label .editcurrent.left.l_nuckh -text "Nutation frequency \[kHz\]:" -width 24 -anchor nw
	label .editcurrent.left.l_nothing -text "" -width 20 -anchor nw 
	button .editcurrent.left.b_cancel -text "cancel" -command {
		destroy .editcurrent
	}
	pack .editcurrent.left.l_prob .editcurrent.left.l_nuc .editcurrent.left.l_nutfreq .editcurrent.left.l_nucdb .editcurrent.left.l_nuckh .editcurrent.left.b_cancel -side top -pady 1 -anchor nw
	entry .editcurrent.right.e_prob -textvariable eprobe  -width 20 
	entry .editcurrent.right.e_nuc -textvariable enuc -width 20 
	entry .editcurrent.right.e_nutfreq -textvariable enutfreq -width 20 
	entry .editcurrent.right.e_nucdb -textvariable enucdb  -width 20 
	entry .editcurrent.right.e_nuckh -textvariable enuckh -width 20 
	button .editcurrent.right.b_save -text "save" -command {
		set entry_y old
		set entry_x old
		for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
			if { $Probenkopf($i) == $eprobe } {
				set probenr $i
				set entry_x old
				break
			} else {
				set probenr [expr $i +1]
				set entry_x new
			}
		}
		for {set i 2} {$i <= [expr [array size nucall] +1]} {incr i} {
				if { [lindex $nucall($i) 0] == $enuc} {
					set nucnr [ expr  $i - 1]
					set entry_y old
					break
				} else {
					set nucnr [expr $i]
					set entry_y new
				}
		}
		if { $entry_y == "old" && $entry_x == "old"} {
			set maxnutfrqu($probenr) $enutfreq
			set daten($probenr) [lreplace $daten($probenr) [expr $nucnr -1 ] $nucnr $enucdb $enuckh ]
		}
		if { $entry_y == "old" && $entry_x == "new"} {
			set Probenkopf([expr [array size Probenkopf] + 1]) $eprobe
			set maxnutfrqu([expr [array size Probenkopf]]) $enutfreq
			set daten([array size Probenkopf]) ""
			for {set i 1} {$i <= [array size nucall]} {incr i} {
				set daten([array size Probenkopf]) "$daten([array size Probenkopf]) x"
			}
			set daten($probenr) [lreplace $daten($probenr) [expr $nucnr -1 ] $nucnr $enucdb $enuckh ]
		}
		if { $entry_y == "new" && $entry_x == "old"} {
			set nucall([expr [array size nucall]+2]) "\"$enuc (dB)\""
			set nucall([expr [array size nucall]+2]) "\"$enuc (kHz)\""
			for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
				set daten($i) "$daten($i) x x "
			}
			set daten($probenr) [lreplace $daten($probenr) [expr $nucnr -1 ] $nucnr $enucdb $enuckh ]
		}
		if { $entry_y == "new" && $entry_x == "new"} {
			set Probenkopf([expr [array size Probenkopf] + 1]) $eprobe
			set maxnutfrqu([expr [array size Probenkopf] ]) $enutfreq
			set daten([array size Probenkopf]) ""
			for {set i 1} {$i <= [array size nucall]} {incr i} {
				set daten([array size Probenkopf]) "$daten([array size Probenkopf]) x"
			}
			set nucall([expr [array size nucall]+2]) "\"$enuc (dB)\""
			set nucall([expr [array size nucall]+2]) "\"$enuc (kHz)\""
			for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
				set daten($i) "$daten($i) x x "
			}
			set daten($probenr) [lreplace $daten($probenr) [expr $nucnr -1 ] $nucnr $enucdb $enuckh ]
		}
		set textrow 0
		for {set row 0} { $row <= [expr [array size txt] - 1]} {incr row} {
			if {[regexp ^\# $txt($row)] || $txt($row) == "" } {
				continue
			}
			if {$textrow == 0} {
				set txt($row) "\"[lindex $txt($row) 0]\" \t"
				for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
					set txt($row) "$txt($row) \"$Probenkopf($i)\" \t"
				}
				incr textrow 
				continue
			}
			if {$textrow == 1} {
				set txt($row) "\"[lindex $txt($row) 0]\" \t"
				for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
					set txt($row) "$txt($row) $maxnutfrqu($i) \t"
				}
				incr textrow 
				continue
			}
			if {$textrow > 1 && $textrow <= [expr [array size nucall] +1]} {
				set txt($row) "\"$nucall($textrow)\" \t"
				for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
					set txt($row) "$txt($row) [lindex $daten($i) [expr $textrow -2]] \t"
				}
				incr textrow 
				continue
			} 
		}
		if {$entry_y == "new"}	{
			
			set txt([expr $row]) "$nucall([expr [array size nucall]]) \t"
			for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
				set txt([expr $row ]) "$txt([expr $row ]) [lindex $daten($i) [expr $textrow -2]] \t"
			}
			set txt([expr $row +1]) "$nucall([expr [array size nucall]+1]) \t"
			for {set i 1} {$i <= [array size Probenkopf]} {incr i} {
				set txt([expr $row +1]) "$txt([expr $row +1]) [lindex $daten($i) [expr $textrow -1]] \t"
			}
		}
		if {[file exists $installdir/Daten.dat] == 1} {
			set Datei [open $installdir/Daten.dat w]
			for {set j 0} {$j <= [expr [array size txt] -1]}  {incr j} {
				puts $Datei $txt($j)
			}
			close $Datei
		}
		destroy .editcurrent
		#read data file
	set Zeilenzahl 0
	set Zeilenzahl1 0
	unset daten
	if {[file exists $installdir/Daten.dat] == 1} {
		set Datei [open $installdir/Daten.dat r]
		while {[gets $Datei Zeile] >= 0} {
			set txt($Zeilenzahl1) $Zeile
			incr Zeilenzahl1
			if {[regexp ^\# $Zeile] || $Zeile == "" } {
				continue
			}
			set headl [llength $Zeile]
			if {$Zeilenzahl == 0} {
				set head [lindex $Zeile 0]
				for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
					set Probenkopf($i) [lindex $Zeile $i]
				}
				incr Zeilenzahl 1
				continue
			}
			if {$Zeilenzahl == 1} {
				for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
					set maxnutfrqu($i) [lindex $Zeile $i]
				}
				incr Zeilenzahl 1
				continue
			}
			set nucall($Zeilenzahl) [lindex $Zeile 0]
			for {set i 1} {$i <= [expr [llength $Zeile]-1]} {incr i} {
				set daten($i) [lappend daten($i) [lindex $Zeile $i]]
			}
			set head [lappend head [lindex $Zeile 0]]
			incr Zeilenzahl 1
		}
	} else {
		tk_messageBox -message "Data file does not exist!" -title "Warning" -type ok
		exit
	}
	close $Datei
	.oben.menus.probenkopf.menue delete 1 last
	.oben.menus.kern.menue delete 1 last
	destroy .oben.menus.probenkopf
	destroy .oben.menus.kern
	destroy .oben.menus.probenkopf.menue
	destroy .oben.menus.kern.menue
	menubutton .oben.menus.probenkopf -text "probe" -menu .oben.menus.probenkopf.menue -relief raised -width 40
	menubutton .oben.menus.kern -text "Nucleus" -menu .oben.menus.kern.menue -relief raised  -width 40
	menu .oben.menus.kern.menue -tearoff 0
	menu .oben.menus.probenkopf.menue -tearoff 0

	for {set i 1} {$i <= [expr $headl-1]} {incr i 1} {
		.oben.menus.probenkopf.menue add cascade -label "$Probenkopf($i)" -menu .oben.menus.probenkopf.menue.$i
		menu .oben.menus.probenkopf.menue.$i -tearoff 0
		.oben.menus.probenkopf.menue.$i add command -label "Select" -command {
			if {[.oben.menus.probenkopf.menue index active] != "none"} {
			set kopfindex [expr [.oben.menus.probenkopf.menue index active] +1]
			.oben.menus.probenkopf configure -text "$Probenkopf($kopfindex)"
			.oben.menus.kern configure -text "Nucleus"
			destroy .oben.menus.kern.menue
			menu .oben.menus.kern.menue -tearoff 0
			for {set j 1} {$j <= [expr [llength $daten($kopfindex)] -1]} {incr j 2} {
				if {[lindex $daten($kopfindex) $j] != "x"} {
					.oben.menus.kern.menue add cascade -label "[lindex [lindex $head [expr $j + 1]] 0 ]" -menu .oben.menus.kern.menue.$j
					menu .oben.menus.kern.menue.$j -tearoff 0
					.oben.menus.kern.menue.$j add command -label "Select" -command {
						if {[.oben.menus.kern.menue index active] != "none"} {
						set kernindex [expr [.oben.menus.kern.menue index active]]
						set g 0
						set add 0
						set ref 0
						while { $ref <= $kernindex} {
							if {[lindex $daten($kopfindex) [expr $g*2]] != "x"} {
								incr ref 1
								incr g 1
							} elseif {[lindex $daten($kopfindex) [expr $g*2]] == "x"} {
								incr add 1
								incr g 1
							}
						}
						set kernindex [expr $kernindex + $add]
						.oben.menus.kern configure -text "[lindex [lindex $head [expr $kernindex*2+2]] 0 ]"
						set pl [lindex $daten($kopfindex) [expr $kernindex *2]]
						set nutfreq  [lindex $daten($kopfindex) [expr $kernindex *2+1] ]
						set probe $Probenkopf($kopfindex)
						set nuc [lindex [lindex $head [expr $kernindex*2+2]] 0 ]
						if {[file exists $configf] == 1} {
							set Dateiw [open "$configf" w]
							puts $Dateiw "set installdir \"$installdir\""
							puts $Dateiw "set probe \"$probe\""
							puts $Dateiw "set nuc \"$nuc\""
							puts $Dateiw "set pl $pl"
							puts $Dateiw "set nutfreq $nutfreq"
							puts $Dateiw "set kopfindex \"$kopfindex\""
							puts $Dateiw "set kernindex \"$kernindex\""
							close $Dateiw
						} else {
							set Dateiw [open "$configf" w]
							puts $Dateiw "set installdir \"$installdir\""
							puts $Dateiw "set Browser \"$Browser\""
							puts $Dateiw "set probe \"$probe\""
							puts $Dateiw "set nuc \"$nuc\""
							puts $Dateiw "set pl $pl"
							puts $Dateiw "set nutfreq $nutfreq"
							puts $Dateiw "set kopfindex \"$kopfindex\""
							puts $Dateiw "set kernindex \"$kernindex\""
							close $Dateiw
						}
					}	
					}
				}
			}
		}
		}
	}
	pack .oben.menus.probenkopf .oben.menus.kern  -side top
	
	}
	pack .editcurrent.right.e_prob .editcurrent.right.e_nuc .editcurrent.right.e_nutfreq .editcurrent.right.e_nucdb .editcurrent.right.e_nuckh .editcurrent.right.b_save  -side top  -anchor nw
	if {$enucdb == "x" && $enuckh == "x"} {
		.editcurrent.right.b_save invoke
	}
}
}



