#!/usr/bin/wish -f
set version 0.3
#TODO: 
#-round off errors
#-T1 und d1 mit stretched exponential
set fontbold "helvetica 10 bold"
set fontbigbold "helvetica 11 bold"
set fontnormal "helvetica 10 normal"
set widthcomment 42
set widtherror 6
set widthentry 8
wm title . "qNMRutility-$version"

frame .m  -background black

frame .m.c0 -relief raised -borderwidth 2 

label .m.c00 -text " " -background LightBlue -font $fontbigbold
label .m.c01 -text "" -background LightBlue -font $fontbigbold
label .m.c02 -text "" -background LightBlue -font $fontbigbold
label .m.c03 -text "analyte" -background LightBlue -font $fontbigbold
label .m.c04 -text "reference" -background LightBlue -font $fontbigbold
label .m.c05 -text "error" -background LightBlue -font $fontbigbold
label .m.c06 -text "comment" -background LightBlue -font $fontbigbold

frame .m.c1 -background black -height 2

set sformref "-"
label .m.c20 -text "sum formula" -font $fontbold -background grey80
label .m.c21 -text "" -font $fontnormal -background grey80
label .m.c22 -text " " -width $widthentry -font $fontnormal -background grey80
label .m.c23 -text " " -width $widthentry -font $fontnormal -background grey80
entry .m.c24 -textvariable sformref -background white -width $widthentry -font $fontnormal
text  .m.c25 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c25 insert 1.0 " "
.m.c25 configure -state disabled
text .m.c26 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c26 insert 1.0 "e.g. C10H16 or SnO1.009"
.m.c26 configure -state disabled

set molmassref 0.0
label .m.c30 -text "molecular mass/(g/mol)" -font $fontbold -background grey85
label .m.c31 -text "" -font $fontnormal -background grey85
label .m.c32 -text " " -width $widthentry -font $fontnormal -background grey85
label .m.c33 -text " " -width $widthentry -font $fontnormal -background grey85
text  .m.c34 -background grey85 -height 1 -width $widthentry -font $fontnormal
.m.c34 insert 1.0  $molmassref
.m.c34 configure -state disabled
text .m.c35 -background grey85 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c35 insert 1.0 " "
.m.c35 configure -state disabled
text .m.c36 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c36 insert 1.0 " "
.m.c36 configure -state disabled

set tau 0.0
set peakareaanalyte 0.0
set peakarearef 0.0
label .m.c40 -text "peak area/(a.u.)" -font $fontbold -background grey80
label .m.c41 -text "" -font $fontnormal -background grey80
button .m.c42 -text "add" -command addrow -font $fontbold -background grey80
entry .m.c43 -textvariable peakareaanalyte -background white -width $widthentry -font $fontnormal
entry .m.c44 -textvariable peakarearef -background white -width $widthentry -font $fontnormal
text .m.c45 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c45 insert 1.0 " "
.m.c45 configure -state disabled
text .m.c46 -background lightyellow -height 2 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c46 insert 1.0 "peak intensities are analyzed pairwise; stddev are calculated if several pairs are available"
.m.c46 configure -state disabled

set massanalyte 0.0
set massref 0.0
set masserror 0.1
label .m.c5000 -text "mass/mg" -font $fontbold  -background grey85
label .m.c5001 -text "" -font $fontnormal -background grey85
label .m.c5002 -text " " -width $widthentry -font $fontnormal -background grey85
entry .m.c5003 -textvariable massanalyte -background white -width $widthentry -font $fontnormal
entry .m.c5004 -textvariable massref -background white -width $widthentry -font $fontnormal
entry .m.c5005 -textvariable masserror -background white -width $widtherror -font $fontnormal
text  .m.c5006 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c5006 insert 1.0 "necessary to characterize the mass ratio"
.m.c5006 configure -state disabled

set xref "-"
label .m.c6000 -text "x/mol" -font $fontbold -background grey80
label .m.c6001 -text "" -font $fontnormal -background grey80
label .m.c6002 -text " " -width $widthentry -font $fontnormal -background grey80
label .m.c6003 -text " " -width $widthentry -font $fontnormal -background grey80
entry .m.c6004 -textvariable xref -background white -width $widthentry -font $fontnormal
text  .m.c6005 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c6005 insert 1.0 " "
.m.c6005 configure -state disabled
text  .m.c6006 -background lightyellow -height 2 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c6006 insert 1.0 "How many formula units of the observed isotope are detected in the sum formula above?"
.m.c6006 configure -state disabled

frame .m.c7 -background black -height 2

set result "press calculate"
set resulterror 0.0
label .m.c8000 -text "=> analyte/(mmol/g)" -font $fontbold -background green1
label .m.c8001 -text "" -font $fontnormal -background green1
label .m.c8002 -text " " -width $widthentry -font $fontnormal -background green1
text  .m.c8003 -background palegreen -height 1 -width $widthentry -font $fontnormal
.m.c8003 insert 1.0  $result
.m.c8003 configure -state disabled
button .m.c8004 -text calculate -command {quantify} -font $fontbold -background green1
text  .m.c8005 -background palegreen -height 1 -font $fontnormal -width $widtherror
.m.c8005 insert 1.0 $resulterror
.m.c8005 configure -state disabled
text .m.c8006 -background palegreen -height 2 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c8006 insert 1.0 "amount of analyte in mmol in the total mass of the analyzed sample"
.m.c8006 configure -state disabled

frame .m.c9 -background black -height 2

set experiment 0
label .m.c10000 -text "experiment: " -font $fontbold -background grey80
label .m.c10001 -text "" -font $fontnormal -background grey80
label .m.c10002 -text " " -width $widthentry -font $fontnormal -background grey80
radiobutton .m.c10003 -text "single pulse excitation" -variable experiment -value 0 -font $fontbold -background grey80 -command {switchexperiment $experiment}
radiobutton .m.c10004 -text "spinecho" -variable experiment -value 1 -font $fontbold -background grey80 -command {switchexperiment $experiment}
text .m.c10005 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c10005 insert 1.0 " "
.m.c10005 configure -state disabled
text .m.c10006 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c10006 insert 1.0 " "
.m.c10006 configure -state disabled

set erroranalysis 0
label .m.c11000 -text "optional: error analysis" -font $fontbold -background grey80
label .m.c11001 -text "" -font $fontnormal -background grey80
label .m.c11002 -text " " -width $widthentry -font $fontnormal -background grey80
radiobutton .m.c11003 -text "off" -command {switchonofferror $erroranalysis} -variable erroranalysis -value 0 -font $fontbold -background grey80
radiobutton .m.c11004 -text "on" -command {switchonofferror $erroranalysis} -variable erroranalysis -value 1 -font $fontbold -background grey80
text  .m.c11005 -background grey80 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror  -height 1
.m.c11005 insert 1.0 " "
.m.c11005 configure -state disabled
text .m.c11006 -background lightyellow -height 3 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c11006 insert 1.0 "errors assume a normal distribution; the true value can be found in a range value-error -- value+error with a probability of 66%"
.m.c11006 configure -state disabled

set offsetanalyte 0.0
set offsetref 0.0
label .m.c12000 -text "resonance offset/Hz" -font $fontbold -background grey85
label .m.c12001 -text "" -font $fontnormal -background grey85
label .m.c12002 -text " " -width $widthentry -font $fontnormal -background grey85
entry .m.c12003 -textvariable offsetanalyte -background white -width $widthentry -font $fontnormal
entry .m.c12004 -textvariable offsetref -background white -width $widthentry -font $fontnormal
text  .m.c12005 -background grey85 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c12005 insert 1.0 " "
.m.c12005 configure -state disabled
text .m.c12006 -background lightyellow -height 2 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c12006 insert 1.0 "The resonance offset must not be bigger than 3.5 * nutation-frequency."
.m.c12006 configure -state disabled

set remainintfactoranalyte 1.0
set remainintfactorref 1.0
label .m.c13000 -text "factor of remaining intensity(offset)" -font $fontbold -background grey80
label .m.c13001 -text "" -font $fontnormal -background grey80
label .m.c13002 -text " " -width $widthentry -font $fontnormal -background grey80
text  .m.c13003 -height 1 -width $widthentry -font $fontnormal -background grey80
.m.c13003 insert 1.0  $remainintfactoranalyte
.m.c13003 configure -state disabled
text .m.c13004 -background grey80 -height 1 -width $widthentry -font $fontnormal
.m.c13004 insert 1.0  $remainintfactorref
.m.c13004 configure -state disabled
text .m.c13005 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c13005 insert 1.0 " "
.m.c13005 configure -state disabled
text .m.c13006 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c13006 insert 1.0 "only valid if no spinning sidebands are visible"
.m.c13006 configure -state disabled

set nutfreq 100000.0
set nutfreqerror 2500.0
label .m.c14000 -text "pulse nutation frequency/Hz" -font $fontbold -background grey85
label .m.c14001 -text "" -font $fontnormal -background grey85
label .m.c14002 -text " " -width $widthentry -font $fontnormal -background grey85
entry .m.c14003 -textvariable nutfreq -background white -width [expr {$widthentry}] -font $fontnormal
entry .m.c14005 -textvariable nutfreqerror -background white -width [expr {$widthentry}] -font $fontnormal
text .m.c14006 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c14006 insert 1.0 "inverse of pulse length (2 pi flip angle)"
.m.c14006 configure -state disabled

set lwhhanalyte 0.0
set lwhhref 0.0
label .m.c15000 -text "line width at half height/Hz" -font $fontbold  -background grey85
label .m.c15001 -text "" -font $fontnormal -background grey85 
label .m.c15002 -text " " -width $widthentry -font $fontnormal -background grey85 
entry .m.c15003 -textvariable lwhhanalyte -background white -width $widthentry -font $fontnormal 
entry .m.c15004 -textvariable lwhhref -background white -width $widthentry -font $fontnormal 
label .m.c15005 -text " " -width $widthentry -font $fontnormal -background grey85 
text  .m.c15006 -background lightyellow -height 2 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment -wrap word
.m.c15006 insert 1.0 "necessary for rough estimate of phase error induced uncertainties"
.m.c15006 configure -state disabled

set phaseerror0 0.0
label .m.c16000 -text "signal phase error/degree" -font $fontbold -background grey80
label .m.c16001 -text "" -font $fontnormal -background grey80
label .m.c16002 -text " " -width $widthentry -font $fontnormal -background grey80
text  .m.c16003 -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
.m.c16003 insert 1.0 " "
.m.c16003 configure -state disabled
entry .m.c16005 -textvariable phaseerror0 -background white -width [expr {$widthentry}] -font $fontnormal
text .m.c16006 -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
.m.c16006 insert 1.0 "stddev of zeroth order phase correction"
.m.c16006 configure -state disabled

proc switchexperiment {value} {
global widthentry fontnormal tauarray tau intensitylist
#add/remove column 1 (forget/remember taucells and)
  set i 1
  if {$value} {
#spinecho
    if {[info exists intensitylist]} {
      foreach element $intensitylist {
        destroy .m.c$element$i
        entry .m.c$element$i -textvariable tauarray($element) -background white -width $widthentry -font $fontnormal
        grid .m.c$element$i -row [expr {$element+1}] -column 1 -sticky wnse -padx 1
      }
    } else {
      set element 4
      destroy .m.c$element$i
      entry .m.c$element$i -textvariable tau -background white -width $widthentry -font $fontnormal
      grid .m.c$element$i -row [expr {$element+1}] -column 1 -sticky wnse -padx 1
    }
    set text "The resonance off must not be bigger than 1.5 times the nutation frequency."
    .m.c01 configure -text "tau/1E-6s"
#label -> entry
  } else {
#spe
    if {[info exists intensitylist]} {
      foreach element $intensitylist {
        destroy .m.c$element$i
        label .m.c$element$i -text "" -font $fontnormal -background grey80
        grid .m.c$element$i -row [expr {$element+1}] -column 1 -sticky wnse -padx 1
      }
    } else {
      set element 4
      destroy .m.c$element$i
      label .m.c$element$i -text "" -font $fontnormal -background grey80
      grid .m.c$element$i -row [expr {$element+1}] -column 1 -sticky wnse -padx 1
    }
    set text "The resonance offset must not be bigger than 3.5 times the nutation frequency."
    .m.c01 configure -text ""
  }
  .m.c12006 configure -state normal
  .m.c12006 delete 1.0 end
  .m.c12006 insert 1.0 $text
  .m.c12006 configure -state disabled
}

proc addrow {} {
  global paaa para tauarray intensitylist experiment peakareaanalyte peakarearef tau fontbold fontnormal widthentry widthcomment widtherror errorcells erroranalysis
  if {[array exists paaa] == 0} {
    array set paaa [list 4 $peakareaanalyte]
    array set para [list 4 $peakarearef]
    .m.c43 configure -textvariable paaa(4)
    .m.c44 configure -textvariable para(4)
    array set tauarray [list 4 $tau]
    set intensitylist [list 4]
    destroy .m.c41
    if {$experiment} {
      entry .m.c41 -textvariable tauarray(4) -background white -width $widthentry -font $fontnormal
    } else {
      label .m.c41 -text "" -font $fontnormal -background grey80
    }
    grid .m.c41 -row 5 -column 1 -sticky wnse -padx 1
  }
  set new [expr {[lindex $intensitylist end]+1}]
  set i 0
  set paaa($new) 0.0
  set para($new) 0.0
  set tauarray($new) 0.0
  lappend intensitylist $new
  label .m.c$new$i -text "" -font $fontbold -background grey80
  grid .m.c$new$i -row [expr {$new+1}] -column 0 -sticky wnse -padx 1
  incr i
  if {$experiment} {
    entry .m.c$new$i -textvariable tauarray($new) -background white -width $widthentry -font $fontnormal
  } else {
    label .m.c$new$i -text "" -font $fontnormal -background grey80
  }
  grid .m.c$new$i -row [expr {$new+1}] -column 1 -sticky nswe -padx 1
  incr i
  button .m.c$new$i -text "rm" -command "rmrow $new" -font $fontbold -background grey80
  grid .m.c$new$i -row [expr {$new+1}] -column 2 -sticky nswe -padx 1
  incr i
  entry .m.c$new$i -textvariable paaa($new) -background white -width $widthentry -font $fontnormal
  grid .m.c$new$i -row [expr {$new+1}] -column 3 -sticky nswe -padx 1
  incr i
  entry .m.c$new$i -textvariable para($new) -background white -width $widthentry -font $fontnormal
  grid .m.c$new$i -row [expr {$new+1}] -column 4 -sticky nswe -padx 1
  incr i
  text .m.c$new$i -background grey80 -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widtherror
  .m.c$new$i insert 1.0 " "
  .m.c$new$i configure -state disabled
  lappend errorcells [list .m.c$new$i [expr {$new+1}] 5 1 nswe 0 0]
  if {$erroranalysis} {
    grid .m.c$new$i -row [expr {$new+1}] -column 5 -sticky nswe -padx 0 -pady 0
  }
  incr i
  text .m.c$new$i -background lightyellow -height 1 -borderwidth 0 -padx 0 -pady 0 -font $fontnormal -width $widthcomment
  .m.c$new$i insert 1.0 "assumes same mass ratio"
  .m.c$new$i configure -state disabled
  grid .m.c$new$i -row [expr {$new+1}] -column 6 -sticky nswe -padx 1
}

# PROC string2file (String, filename, Bool)
# Description:
# writes a string into a file. If file exists, will be overwritten. 
# file. It is possible to append the string to the filename by setting the 
# option to True
proc string2file {string nameoffile {boolappend 0}} {
  if {1!=$boolappend} {
    file delete -force  $nameoffile
  }
  set channel [open $nameoffile a+] 
#  open $nameoffile
  puts  $channel $string
  eof   $channel
  close $channel
}

proc rmrow {row} {
  global paaa para tauarray errorcells intensitylist
#forget row
#remove entry from intensity list
  if {[llength $intensitylist] == 2} {
    set peakareaanalyte $paaa(4)
    set peakarearef $para(4)
    .m.c43 configure -textvariable peakareaanalyte
    .m.c44 configure -textvariable peakarearef
    set tau $tauarray(4)
  }
  foreach element [grid slaves .m -row [expr {$row+1}]] {
    grid remove $element
  }
  for {set i 0} {$i < 7} {incr i} {
    destroy .m.c$row$i
  }
  set searchstring "*.m.c$row"
  append searchstring "5*"
  set pos [lsearch $errorcells $searchstring]
  set errorcells [lreplace $errorcells $pos $pos]
  set intensitylist [lreplace $intensitylist [lsearch $intensitylist $row] [lsearch $intensitylist $row]]
  array unset paaa $row
  array unset para $row
  array unset tauarray $row
  if {[llength $intensitylist] == 1} {
    unset intensitylist
    array unset paaa
    array unset para
    array unset tauarray
  }
}

proc switchonofferror {menuon} {
  global errorcells
  set i [llength $errorcells]
  if {$menuon} {
    foreach element $errorcells {
      if {[string length [lindex $element 0]] > 5} {
        grid [lindex $element 0] -row [lindex $element 1] -column  [lindex $element 2] -columnspan  [lindex $element 3] -sticky [lindex $element 4] -padx  [lindex $element 5] -pady [lindex $element 6]
      }
    }
  } else {
    foreach element $errorcells {
      if {[string length [lindex $element 0]] > 5} {
        grid remove [lindex $element 0]
      }
    }
  }
}

proc quantify {} {
  global sformref molmassref peakareaanalyte peakarearef massanalyte massref ndetref result xref resulterror masserror remainintfactoref remainintfactoranalyte experiment offsetanalyte nutfreq offsetref lwhhref lwhhanalyte phaseerror0 nutfreqerror paaa para tauarray intensitylist erroranalysis
  set docutext "[clock format [clock seconds]]\n"
#calculate molar mass
  set pi [expr {acos(0.0)*2.0}]
  if {[catch {
    set molmassref [calcmolmass $sformref]
    append docutext "sum formula of reference: $sformref\n"
    append docutext "molecular mass of reference: $molmassref g/mol\n"
  }]} {
    set sformref "error: check input"
    return
  } else {
    .m.c34 configure -state normal
    .m.c34 delete 1.0 end
    .m.c34 insert 1.0 $molmassref
    .m.c34 configure -state disabled
  }
#calculate averages and estimate variance of necessary
  if {[info exists intensitylist]} {
    if {$experiment} {
#spinecho
      set peakarearatiolist ""
      set taulist ""
      if {[catch {   
        foreach expno $intensitylist {
          if {[catch {
            append docutext "int.(analyte,$expno): $paaa($expno), int.(ref,$expno): $para($expno), tau($expno): $tauarray($expno)\n"
            lappend peakarearatiolist [expr {double($paaa($expno))/double($para($expno))}]
            lappend taulist $tauarray($expno)
          }]} {
          return
          }
        }
        if {[llength $taulist] > 2} {
          set statres [linearregression $taulist $peakarearatiolist]
          set peakarearatio [lindex $statres 0]
          set peakarearatioerror [lindex $statres 5]
        } else {
          set peakarearatio [expr {[lindex $peakarearatiolist 1]-([lindex $peakarearatiolist 1]-[lindex $peakarearatiolist 0])/([lindex $taulist 1]-[lindex $taulist 0])*[lindex $taulist 1]}]
          set peakarearatioerror 0.0
        }
        }]} {
        set peakarearatio "error"
        set peakarearatioerror 0.0        
      }

    } else {
#SPE
      set peakarearatiolist ""
      foreach expno $intensitylist {
        if {[catch {
          append docutext "int.(analyte,$expno): $paaa($expno), int.(ref,$expno): $para($expno)\n"
          lappend peakarearatiolist [expr {double($paaa($expno))/double($para($expno))}]
        }]} {
          return
        }
      }
      set statres [statistics1d $peakarearatiolist]
      set peakarearatio [lindex $statres 0]
      set peakarearatioerror [lindex $statres 1]
    }
  } else {
    if {[catch {
        append docutext "int.(analyte): $peakareaanalyte \nint.(reference): $peakarearef\n"
        set peakarearatio [expr {double($peakareaanalyte)/double($peakarearef)}]
        set peakarearatioerror 0.0
        }]} {
      set result "error"      
    }
  }
  if {[info exists peakarearatio] && [info exists peakarearatioerror]} {
    append docutext "peak area ratio (analyte/reference): $peakarearatio +/- $peakarearatioerror\n"
  }
#offset correction
  if {[catch {
    set ratiooffref     [expr {double($offsetref)/double($nutfreq)}]
    set ratiooffanalyte [expr {double($offsetanalyte)/double($nutfreq)}]
    }]} {
    set ratiooffref     0.0
    set ratiooffanalyte 0.0
    set result "error"      
  }

  if {$experiment} {
#spinecho
    eval {proc offsetfactor {ratio {pulseerror 0.0}} {return [expr {2.0*(-1.*sqrt(0.0078125+0.03125*pow($ratio,2)-0.03125*pow($ratio,2)*cos(((1.0+$pulseerror)*3.14159265359*sqrt(1.0+pow($ratio,2)))/2.)-0.0078125*cos((1.0+$pulseerror)*3.14159265359*sqrt(1.0+pow($ratio,2))))*(-2.+2.*cos((1.0+$pulseerror)*3.14159265359*sqrt(1.0+pow($ratio,2)))))/pow(1.+pow($ratio,2),2)}]}}
  } else {
    eval {proc offsetfactor {ratio {pulseerror 0.0}} {return [expr {sqrt(1.0-cos(sqrt(1.0+pow($ratio,2))*3.14159265359/2.0*(1.0+$pulseerror)))*sqrt(1.0+2.0*pow($ratio,2)+cos(sqrt(1.0+pow($ratio,2))*3.14159265359/2.0*(1.0+$pulseerror)))/(1.0+1.0*pow($ratio,2))}]}}
#SPE
  }
  if {[catch {
   set remainintfactorref [offsetfactor $ratiooffref]
   set remainintfactoranalyte [offsetfactor $ratiooffanalyte]
  }]!=1} {
  } else {
    set offsetref "0.0"
    set offsetanalyte "0.0"
  }
  if {[catch {
   set ratioofferror [expr {([offsetfactor $ratiooffref 0.00001]/[offsetfactor $ratiooffanalyte 0.00001]-[offsetfactor $ratiooffref -0.00001]/[offsetfactor $ratiooffanalyte -0.00001])/0.00002/$nutfreq}]
    }]!=1} {
  } else {
    set offsetref "error: check input"
    set offsetanalyte "error: check input"
    set ratioofferror 0.0
  }
  if {$erroranalysis} {
    .m.c13003 configure -state normal
    .m.c13003 delete 1.0 end
    .m.c13003 insert 1.0 $remainintfactoranalyte
    .m.c13003 configure -state disabled
    .m.c13004 configure -state normal
    .m.c13004 delete 1.0 end
    .m.c13004 insert 1.0 $remainintfactorref
    .m.c13004 configure -state disabled
  }
#phase error
  if {[catch {
    set deltanu [expr {double($offsetanalyte)-$offsetref}]
    set lambdas [expr {double($lwhhanalyte)+$lwhhref}]
    set x1      [expr {(4.0*$lambdas*$deltanu*($lwhhanalyte*$lambdas+4.0*$lwhhanalyte*$lwhhref*$peakarearatio+4.0*$lwhhref*$lambdas*pow($peakarearatio,2))+16.0*pow($deltanu,3)*($lwhhanalyte+$lwhhref*pow($peakarearatio,2)))/($peakarearatio*(pow(pow($lwhhanalyte,2)-pow($lwhhref,2),2)+8.0*pow($lambdas,2)*pow($deltanu,2)+16.0*pow($deltanu,4)))}]
    }]!=1} {
  } else {
    set x1 0.0
  }
#calculate result and its error
  append docutext "mass analyte: $massanalyte +/- $masserror mg\n"
  append docutext "mass reference: $massref +/- $masserror mg\n"
  append docutext "formula units of detected element: $xref\n"
  if {[catch {
    set result [expr {(double(1000.0)*$peakarearatio*$massref*$remainintfactorref*$xref)/($remainintfactoranalyte*$massanalyte*$molmassref)}]
    }]!=1} {
    if {[catch {
      append docutext "\ncontributions of different error sources:\n"
      append docutext "related to analyte mass: [expr {abs($result*$masserror/$massanalyte)}] mmol/g\n"
      append docutext "related to reference mass: [expr {abs($result*$masserror/$massref)}] mmol/g\n"
      append docutext "related to peak area ratio: [expr {abs($result*$peakarearatioerror/$peakarearatio)}] mmol/g\n"
      append docutext "related to phase error: [expr {abs($result*$x1*double($phaseerror0)/180.0*$pi)}] mmol/g\n"
      append docutext "related to nutation frequency: [expr {abs($result*$ratioofferror*$nutfreqerror)}] mmol/g\n"
      append docutext "The total error is the square root of the summed squares.\n"
      set resulterror [expr {sqrt(\
                       pow($result*$masserror/$massanalyte,2)\
                      +pow($result*$masserror/$massref,2)\
                      +pow($result*$peakarearatioerror/$peakarearatio,2)\
                      +pow($result*0.01/$molmassref,2)\
                      +pow($result*$x1*double($phaseerror0)/180.0*$pi,2)\
                      +pow($result*$ratioofferror*$nutfreqerror,2)\
                       ) }]
      }]!=1} {
    } else {
      set resulterror "error: check input"
    }
  } else {
    set result "error: check input"
  }
  set formattedresult [formatentitywitherror $result $resulterror]
  .m.c8003 configure -state normal
  .m.c8003 delete 1.0 end
  .m.c8003 insert 1.0 [lindex $formattedresult 0]	
  .m.c8003 configure -state disabled
  .m.c8005 configure -state normal
  .m.c8005 delete 1.0 end
  .m.c8005 insert 1.0 [lindex $formattedresult 1]
  .m.c8005 configure -state disabled
  append docutext "\n=>analyte: [lindex $formattedresult 0] +/- [lindex $formattedresult 1] mmol/g"
  string2file $docutext "analysis.txt"
}

proc formatentitywitherror {resulto resulterroro} {
#round off errors need to be fixed
#145+-13; 145.9+-9.6
#die gerundete Stelle muß nach vorne durchgerundet werden; 15.9999 -> 16.0 
 if {[string is double $resulto]&&[string is double $resulterroro]&&$resulterroro>0.0} {
    set resulto [format %.10f $resulto]
    set resulterror [string trimright [format %.10f [fround $resulterroro 2]] 0]
    set diff [format %.10f [expr {$resulto-$resulterror}]]
    set result $resulto
    set i 0
    while {[string index $resulto end-$i]==[string index $diff end-$i] && [string index $resulto end-$i] != "."} {
#      if {[string index $result end-1] == "." && [string index $result end] > 4} {
#        set result [string range $result 0 end-1]
#        set result [string replace $result end-1 end-1 [expr {[string index $result end-1]+1}]]
#        incr i
#      } elseif {[string index $result end] > 4} {
#        set result [string range $result 0 end-1]
#        set result [string replace $result end end [expr {[string index $result end]+1}]]
#        incr i
#      } else {
        set result [string range $result 0 end-1]
        incr i
#      }
    }
  } else {
    set result $resulto
    set resulterror $resulterroro
  }
  return [list $result $resulterror]
}

#calculate mean and sample standard deviation
proc statistics1d {sample} {
#average
  set n 0
  set sum "0.0"
  foreach entry $sample {
    incr n
    append sum "+double($entry)"
  }
  set average [subst "\[expr \{($sum)/double($n)\}\]"]
#sample standard deviation
  set sumsq "0.0"
  foreach entry $sample {
    append sumsq "+pow(double($entry-$average),2)"
  }
  set stdev [subst "\[expr \{sqrt(($sumsq)/double($n-1))\}\]"]
  return [list $average $stdev]
}

# Note: Thr procedure linearregression has been copied and slightly modified from the "tcllib".
# linearregression
#    Determine the coefficients for a linear regression between
#    two series of data (the model: Y = A + B*X)
#
# Arguments:
#    xdata        Series of independent (X) data
#    ydata        Series of dependent (Y) data
#    intercept    Whether to use an intercept or not (optional)
#
# Result:
#    List of the following items:
#    - (Estimate of) Intercept A
#    - (Estimate of) Slope B
#    - Standard deviation of Y relative to fit
#    - Correlation coefficient R2
#    - Number of degrees of freedom df
#    - Standard error of the intercept A
#    - Significance level of A
#    - Standard error of the slope B
#    - Significance level of B
proc linearregression { xdata ydata {intercept 1} } {
  if { [llength $xdata] < 3 || [llength $ydata] < 3 ||[llength $xdata] != [llength $ydata] } {
    return -code error -errorcode ARG  "error: insufficent or incorrect data for linear regression"
  }
  set sumx  0.0
  set sumy  0.0
  set sumx2 0.0
  set sumy2 0.0
  set sumxy 0.0
  set df    0
  foreach x $xdata y $ydata {
    if { $x != "" && $y != "" } {
      set sumx  [expr {$sumx+$x}]
      set sumy  [expr {$sumy+$y}]
      set sumx2 [expr {$sumx2+pow($x,2)}]
      set sumy2 [expr {$sumy2+pow($y,2)}]
      set sumxy [expr {$sumxy+$x*$y}]
      incr df
    }
  }
  if { $df <= 2 } {
    return -code error -errorcode ARG "too few valid data"
  }
  if { $sumx2 == 0.0 } {
    return -code error -errorcode ARG "independent values are all the same"
  }
  #
  # Calculate the intermediate quantities
  #
  set sx  [expr {$sumx2-$sumx*$sumx/$df}]
  set sy  [expr {$sumy2-$sumy*$sumy/$df}]
  set sxy [expr {$sumxy-$sumx*$sumy/$df}]
  #
  # Calculate the coefficients
  #
  if { $intercept } {
    set B [expr {$sxy/$sx}]
    set A [expr {($sumy-$B*$sumx)/$df}]
  } else {
    set B [expr {$sumxy/$sumx2}]
    set A 0.0
  }
  #
  # Calculate the error estimates
  #
  set stdevY 0.0
  set varY   0.0
  if { $intercept } {
    set ve [expr {$sy-$B*$sxy}]
    if { $ve >= 0.0 } {
      set varY [expr {$ve/($df-2)}]
    }
  } else {
    set ve [expr {$sumy2-$B*$sumxy}]
    if { $ve >= 0.0 } {
      set varY [expr {$ve/($df-1)}]
    }
  }
  set seY [expr {sqrt($varY)}]
  if { $intercept } {
    set R2    [expr {$sxy*$sxy/($sx*$sy)}]
    set seA   [expr {$seY*sqrt(1.0/$df+$sumx*$sumx/($sx*$df*$df))}]
    set seB   [expr {sqrt($varY/$sx)}]
    set tA    {}
    set tB    {}
    if { $seA != 0.0 } {
      set tA    [expr {$A/$seA*sqrt($df-2)}]
    }
    if { $seB != 0.0 } {
      set tB    [expr {$B/$seB*sqrt($df-2)}]
    }
  } else {
    set R2    [expr {$sumxy*$sumxy/($sumx2*$sumy2)}]
    set seA   {}
    set tA    {}
    set tB    {}
    set seB   [expr {sqrt($varY/$sumx2)}]
    if { $seB != 0.0 } {
      set tB    [expr {$B/$seB*sqrt($df-1)}]
    }
  }
  #
  # Return the list of parameters
  #
  return [list $A $B $seY $R2 $df $seA $tA $seB $tB]
}

menubutton .m.c0.help -text "?" -menu .m.c0.help.m -underline 0
menubutton .m.c0.file -text "exit" -menu .m.c0.file.m -underline 0
menu .m.c0.help.m -tearoff 0
menu .m.c0.file.m -tearoff 0

.m.c0.help.m add command -label "help" -command {
    hlp_message {qNMRutility} \
            {This program is intended to help with the quantification of NMR signals relative to an internal reference and to help provide reasonable error estimates.}\
            {usage} {Reliable quantification of NMR signals only works with spectra with good signal to noise ratio which have been obtained from a mixture of the reference sample and the to-be-analyzed sample. If you can obtain spectra without spinning sidebands you may apply a correction for the resonance offset which is calculated from analytical formulas. Signal phase errors can introduce a significant amount of uncertainty. An estimate for the standard deviation of the signal phase (related to "phasing" a spectrum in zeroth order) may be obtained by phasing your spectrum manually several times and taking the standard deviation. The presented estimate for the ratio error is based on an analysis for pure Lorentzian lineshapes and error propagation. For 1H-MAS-NMR we got the best results by a combination of spin-echo, intensity back prediction to zero tau delays and automatic phasing. Check out the reference given below for further details. Backprediction is implemented in this tool as well. The results are calculated once the button "calculate" is pressed and are documented in the file "analysis.txt"}\
            {reference} {Y.S. Avadhut, D. Schneider, J. Schmedt auf der Guenne, J. Magn. Reson. 2009 http://dx.doi.org/10.1016/j.jmr.2009.07.019}\
            {final note} {Mental support in form of gummy bears and friendly emails is always welcome.}\
            {copyright (C) 2009 Joern Schmedt auf der Guenne} {
This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version. This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details. You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.}\
}
.m.c0.file.m add command -label "exit program" -command {exit 0}

proc hlp_message {args} {
    set width 800
    #
    # Set up the help window
    toplevel .hlp
    grab .hlp
    wm title .hlp "Help"
    wm minsize .hlp 800 300
    set fontbold "helvetica 10 bold"
    set fontnormal "helvetica 10 normal"
    #
    # Create the window areas
    frame .hlp.top -relief raised -bd 1 
    pack .hlp.top -side top -fill both
    frame .hlp.bot -relief raised -bd 1
    pack .hlp.bot -side bottom -fill both
    #
    # Fill the top part with the message and the bitmap
    set i 0
    label .hlp.top.bitmap -bitmap ""
    pack .hlp.top.bitmap -side left -padx 3m -pady 3m
    foreach text $args {
        if {[expr {fmod($i,2)}]} {
            message .hlp.top.msg$i -width $width -text $text -justify left\
                    -font $fontnormal -anchor w
        } else {
            message .hlp.top.msg$i -width $width -text $text \
                    -font $fontbold
        }
        pack .hlp.top.msg$i -side top -fill x -padx 1m
        incr i
    }
    #
    # Create an exit button
    button .hlp.bot.exit -text Done -command {
        destroy .hlp
    }
    pack .hlp.bot.exit -padx 3m -pady 3m -fill both
    tkwait window .hlp
}

proc fround {float ndigits} {
# XXX check ndigits is in right limits 1 -> infin
#---convert to normal float  
  set float [expr {double($float)}]
  set indexe [string first "e" $float]
  if {$float != 0.0} {
    if {$indexe =="-1"} {
      set mantisse [expr int(floor(log10(abs($float))))]
      set float "[expr {$float/pow(10,$mantisse)}]e$mantisse"
    }
#---round
    set indexdot [string first "." $float]
    set indexe [string first "e" $float]
    if {[expr $indexdot+$ndigits] >= $indexe} {
      set indexcut [expr $indexe-1]
    } else {
      set indexcut [expr $indexdot+$ndigits-1]
    }
    set value "[string range $float 0 $indexcut][string range $float $indexe end]"
  } else {
    set value 0.0
  }
  return $value
}

#---------------
# PROC calcmolmass
# Description: 
# converts a composition (e.g. SnO1.999) into the molar mass
# doesn't know about brackets.
proc calcmolmass {sumformula} {
  set molmass 0.0
  set pselist ""
#data source gchemtable
  lappend pselist  "H" [list   1   1.00794 ]
  lappend pselist "He" [list   2   4.00260 ]
  lappend pselist "Li" [list   3   6.941   ]
  lappend pselist "Be" [list   4   9.01218 ]
  lappend pselist  "B" [list   5  10.81    ]
  lappend pselist  "C" [list   6  12.011   ]
  lappend pselist  "N" [list   7  14.0067  ]
  lappend pselist  "O" [list   8  15.9994  ]
  lappend pselist  "F" [list   9  18.998403]
  lappend pselist "Ne" [list  10  20.179 ]
  lappend pselist "Na" [list  11  22.98977 ]
  lappend pselist "Mg" [list  12  24.305 ]
  lappend pselist "Al" [list  13  26.98154 ]
  lappend pselist "Si" [list  14  28.0855 ]
  lappend pselist  "P" [list  15  30.97376 ]
  lappend pselist  "S" [list  16  32.06 ]
  lappend pselist "Cl" [list  17  35.453 ]
  lappend pselist "Ar" [list  18  39.948 ]
  lappend pselist  "K" [list  19  39.0983 ]
  lappend pselist "Ca" [list  20  40.08 ]
  lappend pselist "Sc" [list  21  44.9559 ]
  lappend pselist "Ti" [list  22  47.88 ]
  lappend pselist  "V" [list  23  50.9415 ]
  lappend pselist "Cr" [list  24  51.996 ]
  lappend pselist "Mn" [list  25  54.9380 ]
  lappend pselist "Fe" [list  26  55.847 ]
  lappend pselist "Co" [list  27  58.9332 ]
  lappend pselist "Ni" [list  28  58.69 ]
  lappend pselist "Cu" [list  29  63.546 ]
  lappend pselist "Zn" [list  30  65.38 ]
  lappend pselist "Ga" [list  31  69.72 ]
  lappend pselist "Ge" [list  32  72.59 ]
  lappend pselist "As" [list  33  74.9216 ]
  lappend pselist "Se" [list  34  78.96 ]
  lappend pselist "Br" [list  35  79.904 ]
  lappend pselist "Kr" [list  36  83.80 ]
  lappend pselist "Rb" [list  37  85.4678 ]
  lappend pselist "Sr" [list  38  87.62 ]
  lappend pselist  "Y" [list  39  88.9059 ]
  lappend pselist "Zr" [list  40  91.22 ]
  lappend pselist "Nb" [list  41  92.9064 ]
  lappend pselist "Mo" [list  42  95.94 ]
  lappend pselist "Tc" [list  43  98.0 ]
  lappend pselist "Ru" [list  44  101.07 ]
  lappend pselist "Rh" [list  45  102.9055 ]
  lappend pselist "Pd" [list  46  106.42 ]
  lappend pselist "Ag" [list  47  107.8682 ]
  lappend pselist "Cd" [list  48  112.41 ]
  lappend pselist "In" [list  49  114.82 ]
  lappend pselist "Sn" [list  50  118.69 ]
  lappend pselist "Sb" [list  51  121.75 ]
  lappend pselist "Te" [list  52  127.60 ]
  lappend pselist  "I" [list  53  126.9045 ]
  lappend pselist "Xe" [list  54  131.29 ]
  lappend pselist "Cs" [list  55  132.9054 ]
  lappend pselist "Ba" [list  56  137.33 ]
  lappend pselist "La" [list  57  138.9055 ]
  lappend pselist "Ce" [list  58  140.12 ]
  lappend pselist "Pr" [list  59  140.9077 ]
  lappend pselist "Nd" [list  60  144.24 ]
  lappend pselist "Pm" [list  61  145 ]
  lappend pselist "Sm" [list  62  150.36 ]
  lappend pselist "Eu" [list  63  151.96 ]
  lappend pselist "Gd" [list  64  157.25 ]
  lappend pselist "Tb" [list  65  158.9254 ]
  lappend pselist "Dy" [list  66  162.50 ]
  lappend pselist "Ho" [list  67  164.9304 ]
  lappend pselist "Er" [list  68  167.26 ]
  lappend pselist "Tm" [list  69  168.9342 ]
  lappend pselist "Yb" [list  70  173.04 ]
  lappend pselist "Lu" [list  71  174.967 ]
  lappend pselist "Hf" [list  72  178.49 ]
  lappend pselist "Ta" [list  73  180.9479 ]
  lappend pselist  "W" [list  74  183.85 ]
  lappend pselist "Re" [list  75  186.207 ]
  lappend pselist "Os" [list  76  190.2 ]
  lappend pselist "Ir" [list  77  192.22 ]
  lappend pselist "Pt" [list  78  195.08 ]
  lappend pselist "Au" [list  79  196.9665 ]
  lappend pselist "Hg" [list  80  200.59 ]
  lappend pselist "Tl" [list  81  204.383 ]
  lappend pselist "Pb" [list  82  207.2 ]
  lappend pselist "Bi" [list  83  208.9804 ]
  lappend pselist "Po" [list  84  84.0 ]
  lappend pselist "At" [list  85  85.0 ]
  lappend pselist "Rn" [list  86  86.0 ]
  array set pse $pselist
  set entries [regexp -all -inline -- {[A-Z][a-z]*[0-9]*\.?[0-9]*e?[-+]?[0-9]{0,3}} $sumformula]
  foreach elemententry $entries {
    set elementfreq [regexp -all -inline -- {^([A-Z][a-z]*)([0-9]*\.?[0-9]*e?[-+]?[0-9]{0,3})$} $elemententry]
    if {[lindex $elementfreq 2] == ""} {
      lset elementfreq 2 1
    }
    set atomicweight [lindex $pse([lindex $elementfreq 1]) 1]
    set frequency [lindex $elementfreq 2]
    set molmass [expr {$molmass+double($frequency)*$atomicweight}]
  }
  return [format "%.2f" $molmass]
}

grid .m -row 0 -column 0

grid .m.c0  -row 0 -column 0 -columnspan 7 -sticky nswe

grid .m.c00 -row 1 -column 0 -sticky nswe -padx 1
grid .m.c01 -row 1 -column 1 -sticky nswe -padx 1
grid .m.c02 -row 1 -column 2 -sticky nswe -padx 1
grid .m.c03 -row 1 -column 3 -sticky nswe -padx 1
grid .m.c04 -row 1 -column 4 -sticky nswe -padx 1
grid .m.c05 -row 1 -column 5 -sticky nswe -padx 0
grid .m.c06 -row 1 -column 6 -sticky nswe -padx 1

grid .m.c1  -row 2 -column 0 -columnspan 7 -sticky nswe

grid .m.c20 -row 3 -column 0 -sticky nswe -padx 1
grid .m.c21 -row 3 -column 1 -sticky nswe -padx 1
grid .m.c22 -row 3 -column 2 -sticky nswe -padx 1
grid .m.c23 -row 3 -column 3 -sticky nswe -padx 1
grid .m.c24 -row 3 -column 4 -sticky nswe -padx 1
grid .m.c25 -row 3 -column 5 -sticky nswe -padx 0
grid .m.c26 -row 3 -column 6 -sticky nswe -padx 1

grid .m.c30 -row 4 -column 0 -sticky nswe -padx 1
grid .m.c31 -row 4 -column 1 -sticky nswe -padx 1
grid .m.c32 -row 4 -column 2 -sticky nswe -padx 1
grid .m.c33 -row 4 -column 3 -sticky nswe -padx 1
grid .m.c34 -row 4 -column 4 -sticky nswe -padx 1
grid .m.c35 -row 4 -column 5 -sticky nswe -padx 0
grid .m.c36 -row 4 -column 6 -sticky nswe -padx 1

grid .m.c40 -row 5 -column 0 -sticky wnse -padx 1
grid .m.c41 -row 5 -column 1 -sticky nswe -padx 1
grid .m.c42 -row 5 -column 2 -sticky nswe -padx 1
grid .m.c43 -row 5 -column 3 -sticky nswe -padx 1
grid .m.c44 -row 5 -column 4 -sticky nswe -padx 1
grid .m.c45 -row 5 -column 5 -sticky nswe -padx 0
grid .m.c46 -row 5 -column 6 -sticky nswe -padx 1

grid .m.c5000 -row 106 -column 0 -sticky nswe -padx 1
grid .m.c5001 -row 106 -column 1 -sticky nswe -padx 1
grid .m.c5002 -row 106 -column 2 -sticky nswe -padx 1
grid .m.c5003 -row 106 -column 3 -sticky nswe -padx 1
grid .m.c5004 -row 106 -column 4 -sticky nswe -padx 1
grid .m.c5005 -row 106 -column 5 -sticky nswe -padx 0
grid .m.c5006 -row 106 -column 6 -sticky nswe -padx 1

grid .m.c6000 -row 107 -column 0 -sticky nswe -padx 1
grid .m.c6001 -row 107 -column 1 -sticky nswe -padx 1
grid .m.c6002 -row 107 -column 2 -sticky nswe -padx 1
grid .m.c6003 -row 107 -column 3 -sticky nswe -padx 1
grid .m.c6004 -row 107 -column 4 -sticky nswe -padx 1
grid .m.c6005 -row 107 -column 5 -sticky nswe -padx 0
grid .m.c6006 -row 107 -column 6 -sticky nswe -padx 1

grid .m.c7  -row 108 -column 0 -columnspan 7 -sticky nswe

grid .m.c8000 -row 109 -column 0 -sticky nswe -padx 0
grid .m.c8001 -row 109 -column 1 -sticky nswe -padx 0
grid .m.c8002 -row 109 -column 2 -sticky nswe -padx 0
grid .m.c8003 -row 109 -column 3 -sticky nswe -padx 0
grid .m.c8004 -row 109 -column 4 -sticky nswe -padx 0
grid .m.c8005 -row 109 -column 5 -sticky nswe -padx 0
grid .m.c8006 -row 109 -column 6 -sticky nswe -padx 0

grid .m.c9  -row 110 -column 0 -columnspan 7 -sticky nswe

grid .m.c10000 -row 111 -column 0 -sticky nswe -padx 0
grid .m.c10001 -row 111 -column 1 -sticky nswe -padx 0
grid .m.c10002 -row 111 -column 2 -sticky nswe -padx 0
grid .m.c10003 -row 111 -column 3 -sticky nswe -padx 0
grid .m.c10004 -row 111 -column 4 -sticky nswe -padx 0
grid .m.c10005 -row 111 -column 5 -sticky nswe -padx 0
grid .m.c10006 -row 111 -column 6 -sticky nswe -padx 0

grid .m.c11000 -row 112 -column 0 -sticky nswe -padx 1
grid .m.c11001 -row 112 -column 1 -sticky nswe -padx 1
grid .m.c11002 -row 112 -column 2 -sticky nswe -padx 1
grid .m.c11003 -row 112 -column 3 -sticky nswe -padx 1
grid .m.c11004 -row 112 -column 4 -sticky nswe -padx 1
grid .m.c11005 -row 112 -column 5 -sticky nswe -padx 0
grid .m.c11006 -row 112 -column 6 -sticky nswe -padx 1

set errorcells ""
foreach errorcell [grid slaves .m -column 5] {
  set errorentry $errorcell
  set infoerrorcell [lrange [split [grid info $errorcell]] 2 end]
  for {set i 0} {$i < [expr {[llength $infoerrorcell]/2}]} {incr i} {
    if {[lindex $infoerrorcell [expr {$i*2}]] == "-row"} {
      set cellrow [lindex $infoerrorcell [expr {$i*2+1}]]
    } elseif {[lindex $infoerrorcell [expr {$i*2}]] == "-column"} {
      set cellcolumn [lindex $infoerrorcell [expr {$i*2+1}]]
    } elseif {[lindex $infoerrorcell [expr {$i*2}]] == "-columnspan"} {
      set cellcolumnspan [lindex $infoerrorcell [expr {$i*2+1}]]
    } elseif {[lindex $infoerrorcell [expr {$i*2}]] == "-sticky"} {
      set cellsticky [lindex $infoerrorcell [expr {$i*2+1}]]
    } elseif {[lindex $infoerrorcell [expr {$i*2}]] == "-padx"} {
      set cellpadx [lindex $infoerrorcell [expr {$i*2+1}]]
    } elseif {[lindex $infoerrorcell [expr {$i*2}]] == "-pady"} {
      set cellpady [lindex $infoerrorcell [expr {$i*2+1}]]
    }
  }
  lappend errorentry $cellrow $cellcolumn $cellcolumnspan $cellsticky $cellpadx $cellpady
  lappend errorcells $errorentry 
}
lappend errorcells [list .m.c12000 113 0 1 nswe 1 0]
lappend errorcells [list .m.c12001 113 1 1 nswe 1 0]
lappend errorcells [list .m.c12002 113 2 1 nswe 1 0]
lappend errorcells [list .m.c12003 113 3 1 nswe 1 0]
lappend errorcells [list .m.c12004 113 4 1 nswe 1 0]
lappend errorcells [list .m.c12005 113 5 1 nswe 0 0]
lappend errorcells [list .m.c12006 113 6 1 nswe 1 0]

lappend errorcells [list .m.c13000 114 0 1 nswe 1 0]
lappend errorcells [list .m.c13001 114 1 1 nswe 1 0]
lappend errorcells [list .m.c13002 114 2 1 nswe 1 0]
lappend errorcells [list .m.c13003 114 3 1 nswe 1 0]
lappend errorcells [list .m.c13004 114 4 1 nswe 1 0]
lappend errorcells [list .m.c13005 114 5 1 nswe 0 0]
lappend errorcells [list .m.c13006 114 6 1 nswe 1 0]

lappend errorcells [list .m.c14000 115 0 1 nswe 0 0]
lappend errorcells [list .m.c14001 115 1 1 nswe 0 0]
lappend errorcells [list .m.c14002 115 2 1 nswe 0 0]
lappend errorcells [list .m.c14003 115 3 2 nswe 0 0]
lappend errorcells [list .m.c14005 115 5 1 nswe 0 0]
lappend errorcells [list .m.c14006 115 6 1 nswe 0 0]

lappend errorcells [list .m.c15000 116 0 1 nswe 1 0]
lappend errorcells [list .m.c15001 116 1 1 nswe 1 0]
lappend errorcells [list .m.c15002 116 2 1 nswe 1 0]
lappend errorcells [list .m.c15003 116 3 1 nswe 1 0]
lappend errorcells [list .m.c15004 116 4 1 nswe 1 0]
lappend errorcells [list .m.c15005 116 5 1 nswe 0 0]
lappend errorcells [list .m.c15006 116 6 1 nswe 1 0]

lappend errorcells [list .m.c16000 117 0 1 nswe 0 0]
lappend errorcells [list .m.c16001 117 1 1 nswe 0 0]
lappend errorcells [list .m.c16002 117 2 1 nswe 0 0]
lappend errorcells [list .m.c16003 117 3 2 nswe 0 0]
lappend errorcells [list .m.c16005 117 5 1 nswe 0 0]
lappend errorcells [list .m.c16006 117 6 1 nswe 0 0]

switchonofferror 0
pack .m.c0.file -side left
pack .m.c0.help -side right
tk_menuBar .m.c0 .m.c0.file .m.c0.help
